package it.auties.whatsapp.model.message.payment;

import it.auties.whatsapp.model.message.payment.PaymentOrderMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class PaymentOrderMessageSpec {
    public static byte[] encode(PaymentOrderMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.id());
var thumbnail = protoInputObject.thumbnail();
if(thumbnail != null) {
var thumbnail0 = thumbnail.orElse(null);
if(thumbnail0 != null) {
outputStream.writeBytes(2, thumbnail0);
}
}
outputStream.writeUInt32(3, protoInputObject.itemCount());
outputStream.writeInt32(4, it.auties.whatsapp.model.message.payment.PaymentOrderMessageStatusSpec.encode(protoInputObject.status()));
outputStream.writeInt32(5, it.auties.whatsapp.model.message.payment.PaymentOrderMessagePaymentOrderSurfaceSpec.encode(protoInputObject.surface()));
var message = protoInputObject.message();
if(message != null) {
var message0 = message.orElse(null);
if(message0 != null) {
outputStream.writeString(6, message0);
}
}
var title = protoInputObject.title();
if(title != null) {
var title0 = title.orElse(null);
if(title0 != null) {
outputStream.writeString(7, title0);
}
}
var sellerId = protoInputObject.sellerId();
if(sellerId != null) {
var sellerId0 = sellerId.toProtobufValue();
if(sellerId0 != null) {
outputStream.writeString(8, sellerId0);
}
}
outputStream.writeString(9, protoInputObject.token());
outputStream.writeUInt64(10, protoInputObject.amount());
outputStream.writeString(11, protoInputObject.currency());
var contextInfo = protoInputObject.contextInfo();
if(contextInfo != null) {
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(17, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
}
      return outputStream.toByteArray();
    }

    public static PaymentOrderMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String id = null;
        byte[] thumbnail = null;
        int itemCount = 0;
        it.auties.whatsapp.model.message.payment.PaymentOrderMessage.Status status = null;
        it.auties.whatsapp.model.message.payment.PaymentOrderMessage.PaymentOrderSurface surface = null;
        java.lang.String message = null;
        java.lang.String title = null;
        it.auties.whatsapp.model.jid.Jid sellerId = null;
        java.lang.String token = null;
        long amount = 0l;
        java.lang.String currency = null;
        it.auties.whatsapp.model.info.ContextInfo contextInfo = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> id = inputStream.readString();
                case 2 -> thumbnail = inputStream.readBytes();
                case 3 -> itemCount = inputStream.readInt32();
                case 4 -> status = it.auties.whatsapp.model.message.payment.PaymentOrderMessageStatusSpec.decode(inputStream.readInt32()).orElse(null);
                case 5 -> surface = it.auties.whatsapp.model.message.payment.PaymentOrderMessagePaymentOrderSurfaceSpec.decode(inputStream.readInt32()).orElse(null);
                case 6 -> message = inputStream.readString();
                case 7 -> title = inputStream.readString();
                case 8 -> sellerId = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 9 -> token = inputStream.readString();
                case 10 -> amount = inputStream.readInt64();
                case 11 -> currency = inputStream.readString();
                case 17 -> contextInfo = it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.payment.PaymentOrderMessage(id, thumbnail, itemCount, status, surface, message, title, sellerId, token, amount, currency, contextInfo);
    }

}
