package it.auties.whatsapp.model.message.payment;

import it.auties.whatsapp.model.message.payment.RequestPaymentMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class RequestPaymentMessageSpec {
    public static byte[] encode(RequestPaymentMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.currency());
outputStream.writeUInt64(2, protoInputObject.amount1000());
var requestFrom = protoInputObject.requestFrom();
if(requestFrom != null) {
var requestFrom0 = requestFrom.toProtobufValue();
if(requestFrom0 != null) {
outputStream.writeString(3, requestFrom0);
}
}
var noteMessage = protoInputObject.noteMessage();
var noteMessage0 = noteMessage.orElse(null);
if(noteMessage0 != null) {
outputStream.writeBytes(4, it.auties.whatsapp.model.message.model.MessageContainerSpec.encode(noteMessage0));
}
outputStream.writeUInt64(5, protoInputObject.expiryTimestampSeconds());
outputStream.writeBytes(6, it.auties.whatsapp.model.payment.PaymentMoneySpec.encode(protoInputObject.amount()));
var background = protoInputObject.background();
var background0 = background.orElse(null);
if(background0 != null) {
outputStream.writeBytes(7, it.auties.whatsapp.model.payment.PaymentBackgroundSpec.encode(background0));
}
      return outputStream.toByteArray();
    }

    public static RequestPaymentMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String currency = null;
        long amount1000 = 0l;
        it.auties.whatsapp.model.jid.Jid requestFrom = null;
        java.util.Optional<it.auties.whatsapp.model.message.model.MessageContainer> noteMessage = java.util.Optional.empty();
        long expiryTimestampSeconds = 0l;
        it.auties.whatsapp.model.payment.PaymentMoney amount = null;
        java.util.Optional<it.auties.whatsapp.model.payment.PaymentBackground> background = java.util.Optional.empty();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> currency = inputStream.readString();
                case 2 -> amount1000 = inputStream.readInt64();
                case 3 -> requestFrom = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 4 -> noteMessage = java.util.Optional.ofNullable(it.auties.whatsapp.model.message.model.MessageContainerSpec.decode(inputStream.readBytes()));
                case 5 -> expiryTimestampSeconds = inputStream.readInt64();
                case 6 -> amount = it.auties.whatsapp.model.payment.PaymentMoneySpec.decode(inputStream.readBytes());
                case 7 -> background = java.util.Optional.ofNullable(it.auties.whatsapp.model.payment.PaymentBackgroundSpec.decode(inputStream.readBytes()));
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.payment.RequestPaymentMessage(currency, amount1000, requestFrom, noteMessage, expiryTimestampSeconds, amount, background);
    }

}
