package it.auties.whatsapp.model.message.server;

import it.auties.whatsapp.model.message.server.DeviceSentMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class DeviceSentMessageSpec {
    public static byte[] encode(DeviceSentMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var destinationJid = protoInputObject.destinationJid();
if(destinationJid != null) {
var destinationJid0 = destinationJid.toProtobufValue();
if(destinationJid0 != null) {
outputStream.writeString(1, destinationJid0);
}
}
outputStream.writeBytes(2, it.auties.whatsapp.model.message.model.MessageContainerSpec.encode(protoInputObject.message()));
var phash = protoInputObject.phash();
var phash0 = phash.orElse(null);
if(phash0 != null) {
outputStream.writeString(3, phash0);
}
      return outputStream.toByteArray();
    }

    public static DeviceSentMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.jid.Jid destinationJid = null;
        it.auties.whatsapp.model.message.model.MessageContainer message = null;
        java.util.Optional<java.lang.String> phash = java.util.Optional.empty();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> destinationJid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 2 -> message = it.auties.whatsapp.model.message.model.MessageContainerSpec.decode(inputStream.readBytes());
                case 3 -> phash = java.util.Optional.ofNullable(inputStream.readString());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.server.DeviceSentMessage(destinationJid, message, phash);
    }

}
