package it.auties.whatsapp.model.message.server;

import it.auties.whatsapp.model.message.server.StickerSyncRMRMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class StickerSyncRMRMessageSpec {
    public static byte[] encode(StickerSyncRMRMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
      if(protoInputObject.hash() != null) {
       for(var hashEntry : protoInputObject.hash()) {
outputStream.writeString(1, hashEntry);
       }
      }
outputStream.writeString(2, protoInputObject.rmrSource());
outputStream.writeInt64(3, protoInputObject.requestTimestamp());
      return outputStream.toByteArray();
    }

    public static StickerSyncRMRMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.util.List<java.lang.String> hash = new java.util.ArrayList<java.lang.String>();
        java.lang.String rmrSource = null;
        long requestTimestamp = 0l;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> hash.add(inputStream.readString());
                case 2 -> rmrSource = inputStream.readString();
                case 3 -> requestTimestamp = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.server.StickerSyncRMRMessage(hash, rmrSource, requestTimestamp);
    }

}
