package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.message.standard.CallMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class CallMessageSpec {
    public static byte[] encode(CallMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, protoInputObject.key());
outputStream.writeString(2, protoInputObject.source());
outputStream.writeBytes(3, protoInputObject.data());
outputStream.writeUInt32(4, protoInputObject.delay());
      return outputStream.toByteArray();
    }

    public static CallMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] key = null;
        java.lang.String source = null;
        byte[] data = null;
        int delay = 0;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> key = inputStream.readBytes();
                case 2 -> source = inputStream.readString();
                case 3 -> data = inputStream.readBytes();
                case 4 -> delay = inputStream.readInt32();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.standard.CallMessage(key, source, data, delay);
    }

}
