package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.message.standard.ContactMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ContactMessageSpec {
    public static byte[] encode(ContactMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.name());
var vcard = protoInputObject.vcard();
if(vcard != null) {
var vcard0 = vcard.toVcard();
if(vcard0 != null) {
outputStream.writeString(16, vcard0);
}
}
var contextInfo = protoInputObject.contextInfo();
if(contextInfo != null) {
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(17, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
}
      return outputStream.toByteArray();
    }

    public static ContactMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String name = null;
        it.auties.whatsapp.model.contact.ContactCard vcard = null;
        it.auties.whatsapp.model.info.ContextInfo contextInfo = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> name = inputStream.readString();
                case 16 -> vcard = it.auties.whatsapp.model.contact.ContactCard.ofProtobuf(inputStream.readString());
                case 17 -> contextInfo = it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.standard.ContactMessage(name, vcard, contextInfo);
    }

}
