package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.message.standard.ImageMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ImageMessageSpec {
    public static byte[] encode(ImageMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var mediaUrl = protoInputObject.mediaUrl();
if(mediaUrl != null) {
var mediaUrl0 = mediaUrl.orElse(null);
if(mediaUrl0 != null) {
outputStream.writeString(1, mediaUrl0);
}
}
var mimetype = protoInputObject.mimetype();
if(mimetype != null) {
var mimetype0 = mimetype.orElse(null);
if(mimetype0 != null) {
outputStream.writeString(2, mimetype0);
}
}
var caption = protoInputObject.caption();
if(caption != null) {
var caption0 = caption.orElse(null);
if(caption0 != null) {
outputStream.writeString(3, caption0);
}
}
var mediaSha256 = protoInputObject.mediaSha256();
if(mediaSha256 != null) {
var mediaSha2560 = mediaSha256.orElse(null);
if(mediaSha2560 != null) {
outputStream.writeBytes(4, mediaSha2560);
}
}
var mediaSize = protoInputObject.mediaSize();
if(mediaSize != null) {
var mediaSize0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(mediaSize);
if(mediaSize0 != null) {
outputStream.writeUInt64(5, mediaSize0);
}
}
var height = protoInputObject.height();
if(height != null) {
var height0 = it.auties.protobuf.extension.OptionalExtension.toNullableInt(height);
if(height0 != null) {
outputStream.writeUInt32(6, height0);
}
}
var width = protoInputObject.width();
if(width != null) {
var width0 = it.auties.protobuf.extension.OptionalExtension.toNullableInt(width);
if(width0 != null) {
outputStream.writeUInt32(7, width0);
}
}
var mediaKey = protoInputObject.mediaKey();
if(mediaKey != null) {
var mediaKey0 = mediaKey.orElse(null);
if(mediaKey0 != null) {
outputStream.writeBytes(8, mediaKey0);
}
}
var mediaEncryptedSha256 = protoInputObject.mediaEncryptedSha256();
if(mediaEncryptedSha256 != null) {
var mediaEncryptedSha2560 = mediaEncryptedSha256.orElse(null);
if(mediaEncryptedSha2560 != null) {
outputStream.writeBytes(9, mediaEncryptedSha2560);
}
}
      if(protoInputObject.interactiveAnnotations() != null) {
       for(var interactiveAnnotationsEntry : protoInputObject.interactiveAnnotations()) {
outputStream.writeBytes(10, it.auties.whatsapp.model.button.interactive.InteractiveLocationAnnotationSpec.encode(interactiveAnnotationsEntry));
       }
      }
var mediaDirectPath = protoInputObject.mediaDirectPath();
if(mediaDirectPath != null) {
var mediaDirectPath0 = mediaDirectPath.orElse(null);
if(mediaDirectPath0 != null) {
outputStream.writeString(11, mediaDirectPath0);
}
}
var mediaKeyTimestampSeconds = protoInputObject.mediaKeyTimestampSeconds();
if(mediaKeyTimestampSeconds != null) {
var mediaKeyTimestampSeconds0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(mediaKeyTimestampSeconds);
if(mediaKeyTimestampSeconds0 != null) {
outputStream.writeUInt64(12, mediaKeyTimestampSeconds0);
}
}
var thumbnail = protoInputObject.thumbnail();
if(thumbnail != null) {
var thumbnail0 = thumbnail.orElse(null);
if(thumbnail0 != null) {
outputStream.writeBytes(16, thumbnail0);
}
}
var contextInfo = protoInputObject.contextInfo();
if(contextInfo != null) {
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(17, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
}
var firstScanSidecar = protoInputObject.firstScanSidecar();
if(firstScanSidecar != null) {
var firstScanSidecar0 = firstScanSidecar.orElse(null);
if(firstScanSidecar0 != null) {
outputStream.writeBytes(18, firstScanSidecar0);
}
}
var firstScanLength = protoInputObject.firstScanLength();
if(firstScanLength != null) {
var firstScanLength0 = it.auties.protobuf.extension.OptionalExtension.toNullableInt(firstScanLength);
if(firstScanLength0 != null) {
outputStream.writeUInt32(19, firstScanLength0);
}
}
var experimentGroupId = protoInputObject.experimentGroupId();
if(experimentGroupId != null) {
var experimentGroupId0 = it.auties.protobuf.extension.OptionalExtension.toNullableInt(experimentGroupId);
if(experimentGroupId0 != null) {
outputStream.writeUInt32(20, experimentGroupId0);
}
}
var scansSidecar = protoInputObject.scansSidecar();
if(scansSidecar != null) {
var scansSidecar0 = scansSidecar.orElse(null);
if(scansSidecar0 != null) {
outputStream.writeBytes(21, scansSidecar0);
}
}
      if(protoInputObject.scanLengths() != null) {
       for(var scanLengthsEntry : protoInputObject.scanLengths()) {
outputStream.writeUInt32(22, scanLengthsEntry);
       }
      }
var midQualityFileSha256 = protoInputObject.midQualityFileSha256();
if(midQualityFileSha256 != null) {
var midQualityFileSha2560 = midQualityFileSha256.orElse(null);
if(midQualityFileSha2560 != null) {
outputStream.writeBytes(23, midQualityFileSha2560);
}
}
var midQualityFileEncSha256 = protoInputObject.midQualityFileEncSha256();
if(midQualityFileEncSha256 != null) {
var midQualityFileEncSha2560 = midQualityFileEncSha256.orElse(null);
if(midQualityFileEncSha2560 != null) {
outputStream.writeBytes(24, midQualityFileEncSha2560);
}
}
outputStream.writeBool(25, protoInputObject.viewOnce());
var thumbnailDirectPath = protoInputObject.thumbnailDirectPath();
if(thumbnailDirectPath != null) {
var thumbnailDirectPath0 = thumbnailDirectPath.orElse(null);
if(thumbnailDirectPath0 != null) {
outputStream.writeString(26, thumbnailDirectPath0);
}
}
var thumbnailSha256 = protoInputObject.thumbnailSha256();
if(thumbnailSha256 != null) {
var thumbnailSha2560 = thumbnailSha256.orElse(null);
if(thumbnailSha2560 != null) {
outputStream.writeBytes(27, thumbnailSha2560);
}
}
var thumbnailEncSha256 = protoInputObject.thumbnailEncSha256();
if(thumbnailEncSha256 != null) {
var thumbnailEncSha2560 = thumbnailEncSha256.orElse(null);
if(thumbnailEncSha2560 != null) {
outputStream.writeBytes(28, thumbnailEncSha2560);
}
}
var staticUrl = protoInputObject.staticUrl();
if(staticUrl != null) {
var staticUrl0 = staticUrl.orElse(null);
if(staticUrl0 != null) {
outputStream.writeString(29, staticUrl0);
}
}
      return outputStream.toByteArray();
    }

    public static ImageMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String mediaUrl = null;
        java.lang.String mimetype = null;
        java.lang.String caption = null;
        byte[] mediaSha256 = null;
        java.lang.Long mediaSize = null;
        java.lang.Integer height = null;
        java.lang.Integer width = null;
        byte[] mediaKey = null;
        byte[] mediaEncryptedSha256 = null;
        java.util.List<it.auties.whatsapp.model.button.interactive.InteractiveLocationAnnotation> interactiveAnnotations = new java.util.ArrayList<it.auties.whatsapp.model.button.interactive.InteractiveLocationAnnotation>();
        java.lang.String mediaDirectPath = null;
        java.lang.Long mediaKeyTimestampSeconds = null;
        byte[] thumbnail = null;
        it.auties.whatsapp.model.info.ContextInfo contextInfo = null;
        byte[] firstScanSidecar = null;
        java.lang.Integer firstScanLength = null;
        java.lang.Integer experimentGroupId = null;
        byte[] scansSidecar = null;
        java.util.List<java.lang.Integer> scanLengths = new java.util.ArrayList<java.lang.Integer>();
        byte[] midQualityFileSha256 = null;
        byte[] midQualityFileEncSha256 = null;
        boolean viewOnce = false;
        java.lang.String thumbnailDirectPath = null;
        byte[] thumbnailSha256 = null;
        byte[] thumbnailEncSha256 = null;
        java.lang.String staticUrl = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> mediaUrl = inputStream.readString();
                case 2 -> mimetype = inputStream.readString();
                case 3 -> caption = inputStream.readString();
                case 4 -> mediaSha256 = inputStream.readBytes();
                case 5 -> mediaSize = inputStream.readInt64();
                case 6 -> height = inputStream.readInt32();
                case 7 -> width = inputStream.readInt32();
                case 8 -> mediaKey = inputStream.readBytes();
                case 9 -> mediaEncryptedSha256 = inputStream.readBytes();
                case 10 -> interactiveAnnotations.add(it.auties.whatsapp.model.button.interactive.InteractiveLocationAnnotationSpec.decode(inputStream.readBytes()));
                case 11 -> mediaDirectPath = inputStream.readString();
                case 12 -> mediaKeyTimestampSeconds = inputStream.readInt64();
                case 16 -> thumbnail = inputStream.readBytes();
                case 17 -> contextInfo = it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes());
                case 18 -> firstScanSidecar = inputStream.readBytes();
                case 19 -> firstScanLength = inputStream.readInt32();
                case 20 -> experimentGroupId = inputStream.readInt32();
                case 21 -> scansSidecar = inputStream.readBytes();
                case 22 -> scanLengths.add(inputStream.readInt32());
                case 23 -> midQualityFileSha256 = inputStream.readBytes();
                case 24 -> midQualityFileEncSha256 = inputStream.readBytes();
                case 25 -> viewOnce = inputStream.readBool();
                case 26 -> thumbnailDirectPath = inputStream.readString();
                case 27 -> thumbnailSha256 = inputStream.readBytes();
                case 28 -> thumbnailEncSha256 = inputStream.readBytes();
                case 29 -> staticUrl = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.standard.ImageMessage(mediaUrl, mimetype, caption, mediaSha256, mediaSize, height, width, mediaKey, mediaEncryptedSha256, interactiveAnnotations, mediaDirectPath, mediaKeyTimestampSeconds, thumbnail, contextInfo, firstScanSidecar, firstScanLength, experimentGroupId, scansSidecar, scanLengths, midQualityFileSha256, midQualityFileEncSha256, viewOnce, thumbnailDirectPath, thumbnailSha256, thumbnailEncSha256, staticUrl);
    }

}
