package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.message.standard.LocationMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class LocationMessageSpec {
    public static byte[] encode(LocationMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeDouble(1, protoInputObject.latitude());
outputStream.writeDouble(2, protoInputObject.longitude());
var name = protoInputObject.name();
if(name != null) {
var name0 = name.orElse(null);
if(name0 != null) {
outputStream.writeString(3, name0);
}
}
var address = protoInputObject.address();
if(address != null) {
var address0 = address.orElse(null);
if(address0 != null) {
outputStream.writeString(4, address0);
}
}
var url = protoInputObject.url();
if(url != null) {
var url0 = url.orElse(null);
if(url0 != null) {
outputStream.writeString(5, url0);
}
}
outputStream.writeBool(6, protoInputObject.live());
outputStream.writeUInt32(7, protoInputObject.accuracy());
outputStream.writeFloat(8, protoInputObject.speed());
outputStream.writeUInt32(9, protoInputObject.magneticNorthOffset());
var caption = protoInputObject.caption();
if(caption != null) {
var caption0 = caption.orElse(null);
if(caption0 != null) {
outputStream.writeString(11, caption0);
}
}
var thumbnail = protoInputObject.thumbnail();
if(thumbnail != null) {
var thumbnail0 = thumbnail.orElse(null);
if(thumbnail0 != null) {
outputStream.writeBytes(16, thumbnail0);
}
}
var contextInfo = protoInputObject.contextInfo();
if(contextInfo != null) {
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(17, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
}
      return outputStream.toByteArray();
    }

    public static LocationMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        double latitude = 0d;
        double longitude = 0d;
        java.lang.String name = null;
        java.lang.String address = null;
        java.lang.String url = null;
        boolean live = false;
        int accuracy = 0;
        float speed = 0f;
        int magneticNorthOffset = 0;
        java.lang.String caption = null;
        byte[] thumbnail = null;
        it.auties.whatsapp.model.info.ContextInfo contextInfo = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> latitude = inputStream.readDouble();
                case 2 -> longitude = inputStream.readDouble();
                case 3 -> name = inputStream.readString();
                case 4 -> address = inputStream.readString();
                case 5 -> url = inputStream.readString();
                case 6 -> live = inputStream.readBool();
                case 7 -> accuracy = inputStream.readInt32();
                case 8 -> speed = inputStream.readFloat();
                case 9 -> magneticNorthOffset = inputStream.readInt32();
                case 11 -> caption = inputStream.readString();
                case 16 -> thumbnail = inputStream.readBytes();
                case 17 -> contextInfo = it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.standard.LocationMessage(latitude, longitude, name, address, url, live, accuracy, speed, magneticNorthOffset, caption, thumbnail, contextInfo);
    }

}
