package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.message.standard.PollCreationMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class PollCreationMessageSpec {
    public static byte[] encode(PollCreationMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var encryptionKey = protoInputObject.encryptionKey();
if(encryptionKey != null) {
var encryptionKey0 = encryptionKey.orElse(null);
if(encryptionKey0 != null) {
outputStream.writeBytes(1, encryptionKey0);
}
}
outputStream.writeString(2, protoInputObject.title());
      if(protoInputObject.selectableOptions() != null) {
       for(var selectableOptionsEntry : protoInputObject.selectableOptions()) {
outputStream.writeBytes(3, it.auties.whatsapp.model.poll.PollOptionSpec.encode(selectableOptionsEntry));
       }
      }
outputStream.writeUInt32(4, protoInputObject.selectableOptionsCount());
var contextInfo = protoInputObject.contextInfo();
if(contextInfo != null) {
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(5, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
}
      if(protoInputObject.selectableOptionsMap != null) {
            for(var selectableOptionsMapEntry : protoInputObject.selectableOptionsMap.entrySet()) {
                var selectableOptionsMapOutputStream = new ProtobufOutputStream();
selectableOptionsMapOutputStream.writeString(1, selectableOptionsMapEntry.getKey());
selectableOptionsMapOutputStream.writeBytes(2, it.auties.whatsapp.model.poll.PollOptionSpec.encode(selectableOptionsMapEntry.getValue()));
                outputStream.writeBytes(999, selectableOptionsMapOutputStream.toByteArray());
            }
      }
      if(protoInputObject.selectedOptions != null) {
       for(var selectedOptionsEntry : protoInputObject.selectedOptions) {
outputStream.writeBytes(1000, it.auties.whatsapp.model.poll.SelectedPollOptionSpec.encode(selectedOptionsEntry));
       }
      }
      return outputStream.toByteArray();
    }

    public static PollCreationMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] encryptionKey = null;
        java.lang.String title = null;
        java.util.List<it.auties.whatsapp.model.poll.PollOption> selectableOptions = new java.util.ArrayList<it.auties.whatsapp.model.poll.PollOption>();
        int selectableOptionsCount = 0;
        it.auties.whatsapp.model.info.ContextInfo contextInfo = null;
        java.util.Map<java.lang.String,it.auties.whatsapp.model.poll.PollOption> selectableOptionsMap = new java.util.HashMap<java.lang.String,it.auties.whatsapp.model.poll.PollOption>();
        java.util.List<it.auties.whatsapp.model.poll.SelectedPollOption> selectedOptions = new java.util.ArrayList<it.auties.whatsapp.model.poll.SelectedPollOption>();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> encryptionKey = inputStream.readBytes();
                case 2 -> title = inputStream.readString();
                case 3 -> selectableOptions.add(it.auties.whatsapp.model.poll.PollOptionSpec.decode(inputStream.readBytes()));
                case 4 -> selectableOptionsCount = inputStream.readInt32();
                case 5 -> contextInfo = it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes());
                case 999 -> {
                        var selectableOptionsMapInputStream = new ProtobufInputStream(inputStream.readBytes());
                        java.lang.String selectableOptionsMapKey = null;
                        it.auties.whatsapp.model.poll.PollOption selectableOptionsMapValue = null;
                        while(selectableOptionsMapInputStream.readTag()) {
                            switch(selectableOptionsMapInputStream.index()) {
                                case 1 -> selectableOptionsMapKey = selectableOptionsMapInputStream.readString();
                                case 2 -> selectableOptionsMapValue = it.auties.whatsapp.model.poll.PollOptionSpec.decode(selectableOptionsMapInputStream.readBytes());
                            }
                        }
                        selectableOptionsMap.put(selectableOptionsMapKey, selectableOptionsMapValue);
                }
                case 1000 -> selectedOptions.add(it.auties.whatsapp.model.poll.SelectedPollOptionSpec.decode(inputStream.readBytes()));
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.standard.PollCreationMessage(encryptionKey, title, selectableOptions, selectableOptionsCount, contextInfo, selectableOptionsMap, selectedOptions);
    }

}
