package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.message.standard.ProductMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ProductMessageSpec {
    public static byte[] encode(ProductMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, it.auties.whatsapp.model.product.ProductSpec.encode(protoInputObject.product()));
var businessOwnerJid = protoInputObject.businessOwnerJid();
if(businessOwnerJid != null) {
var businessOwnerJid0 = businessOwnerJid.toProtobufValue();
if(businessOwnerJid0 != null) {
outputStream.writeString(2, businessOwnerJid0);
}
}
outputStream.writeBytes(4, it.auties.whatsapp.model.product.ProductCatalogSpec.encode(protoInputObject.catalog()));
var body = protoInputObject.body();
if(body != null) {
var body0 = body.orElse(null);
if(body0 != null) {
outputStream.writeString(5, body0);
}
}
var footer = protoInputObject.footer();
if(footer != null) {
var footer0 = footer.orElse(null);
if(footer0 != null) {
outputStream.writeString(6, footer0);
}
}
var contextInfo = protoInputObject.contextInfo();
if(contextInfo != null) {
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(17, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
}
      return outputStream.toByteArray();
    }

    public static ProductMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.product.Product product = null;
        it.auties.whatsapp.model.jid.Jid businessOwnerJid = null;
        it.auties.whatsapp.model.product.ProductCatalog catalog = null;
        java.lang.String body = null;
        java.lang.String footer = null;
        it.auties.whatsapp.model.info.ContextInfo contextInfo = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> product = it.auties.whatsapp.model.product.ProductSpec.decode(inputStream.readBytes());
                case 2 -> businessOwnerJid = it.auties.whatsapp.model.jid.Jid.ofProtobuf(inputStream.readString());
                case 4 -> catalog = it.auties.whatsapp.model.product.ProductCatalogSpec.decode(inputStream.readBytes());
                case 5 -> body = inputStream.readString();
                case 6 -> footer = inputStream.readString();
                case 17 -> contextInfo = it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.standard.ProductMessage(product, businessOwnerJid, catalog, body, footer, contextInfo);
    }

}
