package it.auties.whatsapp.model.message.standard;

import it.auties.whatsapp.model.message.standard.TextMessage;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class TextMessageSpec {
    public static byte[] encode(TextMessage protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.text());
var matchedText = protoInputObject.matchedText();
if(matchedText != null) {
var matchedText0 = matchedText.orElse(null);
if(matchedText0 != null) {
outputStream.writeString(2, matchedText0);
}
}
var canonicalUrl = protoInputObject.canonicalUrl();
if(canonicalUrl != null) {
var canonicalUrl0 = canonicalUrl.orElse(null);
if(canonicalUrl0 != null) {
outputStream.writeString(4, canonicalUrl0);
}
}
var description = protoInputObject.description();
if(description != null) {
var description0 = description.orElse(null);
if(description0 != null) {
outputStream.writeString(5, description0);
}
}
var title = protoInputObject.title();
if(title != null) {
var title0 = title.orElse(null);
if(title0 != null) {
outputStream.writeString(6, title0);
}
}
outputStream.writeFixed32(7, protoInputObject.textArgb());
var backgroundArgb = protoInputObject.backgroundArgb();
if(backgroundArgb != null) {
var backgroundArgb0 = it.auties.protobuf.extension.OptionalExtension.toNullableInt(backgroundArgb);
if(backgroundArgb0 != null) {
outputStream.writeFixed32(8, backgroundArgb0);
}
}
var font = protoInputObject.font();
if(font != null) {
var font0 = font.orElse(null);
if(font0 != null) {
outputStream.writeInt32(9, it.auties.whatsapp.model.message.standard.TextMessageFontTypeSpec.encode(font0));
}
}
var previewType = protoInputObject.previewType();
if(previewType != null) {
var previewType0 = previewType.orElse(null);
if(previewType0 != null) {
outputStream.writeInt32(10, it.auties.whatsapp.model.message.standard.TextMessagePreviewTypeSpec.encode(previewType0));
}
}
var thumbnail = protoInputObject.thumbnail();
if(thumbnail != null) {
var thumbnail0 = thumbnail.orElse(null);
if(thumbnail0 != null) {
outputStream.writeBytes(16, thumbnail0);
}
}
var contextInfo = protoInputObject.contextInfo();
if(contextInfo != null) {
var contextInfo0 = contextInfo.orElse(null);
if(contextInfo0 != null) {
outputStream.writeBytes(17, it.auties.whatsapp.model.info.ContextInfoSpec.encode(contextInfo0));
}
}
outputStream.writeBool(18, protoInputObject.doNotPlayInline());
var thumbnailDirectPath = protoInputObject.thumbnailDirectPath();
if(thumbnailDirectPath != null) {
var thumbnailDirectPath0 = thumbnailDirectPath.orElse(null);
if(thumbnailDirectPath0 != null) {
outputStream.writeString(19, thumbnailDirectPath0);
}
}
var thumbnailSha256 = protoInputObject.thumbnailSha256();
if(thumbnailSha256 != null) {
var thumbnailSha2560 = thumbnailSha256.orElse(null);
if(thumbnailSha2560 != null) {
outputStream.writeBytes(20, thumbnailSha2560);
}
}
var thumbnailEncSha256 = protoInputObject.thumbnailEncSha256();
if(thumbnailEncSha256 != null) {
var thumbnailEncSha2560 = thumbnailEncSha256.orElse(null);
if(thumbnailEncSha2560 != null) {
outputStream.writeBytes(21, thumbnailEncSha2560);
}
}
var mediaKey = protoInputObject.mediaKey();
if(mediaKey != null) {
var mediaKey0 = mediaKey.orElse(null);
if(mediaKey0 != null) {
outputStream.writeBytes(22, mediaKey0);
}
}
var mediaKeyTimestampSeconds = protoInputObject.mediaKeyTimestampSeconds();
if(mediaKeyTimestampSeconds != null) {
var mediaKeyTimestampSeconds0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(mediaKeyTimestampSeconds);
if(mediaKeyTimestampSeconds0 != null) {
outputStream.writeInt64(23, mediaKeyTimestampSeconds0);
}
}
var thumbnailHeight = protoInputObject.thumbnailHeight();
if(thumbnailHeight != null) {
var thumbnailHeight0 = it.auties.protobuf.extension.OptionalExtension.toNullableInt(thumbnailHeight);
if(thumbnailHeight0 != null) {
outputStream.writeUInt32(24, thumbnailHeight0);
}
}
var thumbnailWidth = protoInputObject.thumbnailWidth();
if(thumbnailWidth != null) {
var thumbnailWidth0 = it.auties.protobuf.extension.OptionalExtension.toNullableInt(thumbnailWidth);
if(thumbnailWidth0 != null) {
outputStream.writeUInt32(25, thumbnailWidth0);
}
}
var inviteLinkGroupType = protoInputObject.inviteLinkGroupType();
if(inviteLinkGroupType != null) {
var inviteLinkGroupType0 = inviteLinkGroupType.orElse(null);
if(inviteLinkGroupType0 != null) {
outputStream.writeInt32(26, it.auties.whatsapp.model.message.standard.TextMessageInviteLinkGroupTypeSpec.encode(inviteLinkGroupType0));
}
}
var inviteLinkParentGroupSubjectV2 = protoInputObject.inviteLinkParentGroupSubjectV2();
if(inviteLinkParentGroupSubjectV2 != null) {
var inviteLinkParentGroupSubjectV20 = inviteLinkParentGroupSubjectV2.orElse(null);
if(inviteLinkParentGroupSubjectV20 != null) {
outputStream.writeString(27, inviteLinkParentGroupSubjectV20);
}
}
var inviteLinkParentGroupThumbnailV2 = protoInputObject.inviteLinkParentGroupThumbnailV2();
if(inviteLinkParentGroupThumbnailV2 != null) {
var inviteLinkParentGroupThumbnailV20 = inviteLinkParentGroupThumbnailV2.orElse(null);
if(inviteLinkParentGroupThumbnailV20 != null) {
outputStream.writeBytes(28, inviteLinkParentGroupThumbnailV20);
}
}
var inviteLinkGroupTypeV2 = protoInputObject.inviteLinkGroupTypeV2();
if(inviteLinkGroupTypeV2 != null) {
var inviteLinkGroupTypeV20 = inviteLinkGroupTypeV2.orElse(null);
if(inviteLinkGroupTypeV20 != null) {
outputStream.writeInt32(29, it.auties.whatsapp.model.message.standard.TextMessageInviteLinkGroupTypeSpec.encode(inviteLinkGroupTypeV20));
}
}
outputStream.writeBool(30, protoInputObject.viewOnce());
      return outputStream.toByteArray();
    }

    public static TextMessage decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String text = null;
        java.lang.String matchedText = null;
        java.lang.String canonicalUrl = null;
        java.lang.String description = null;
        java.lang.String title = null;
        java.lang.Integer textArgb = null;
        java.lang.Integer backgroundArgb = null;
        it.auties.whatsapp.model.message.standard.TextMessage.FontType font = null;
        it.auties.whatsapp.model.message.standard.TextMessage.PreviewType previewType = null;
        byte[] thumbnail = null;
        it.auties.whatsapp.model.info.ContextInfo contextInfo = null;
        boolean doNotPlayInline = false;
        java.lang.String thumbnailDirectPath = null;
        byte[] thumbnailSha256 = null;
        byte[] thumbnailEncSha256 = null;
        byte[] mediaKey = null;
        java.lang.Long mediaKeyTimestampSeconds = null;
        java.lang.Integer thumbnailHeight = null;
        java.lang.Integer thumbnailWidth = null;
        it.auties.whatsapp.model.message.standard.TextMessage.InviteLinkGroupType inviteLinkGroupType = null;
        java.lang.String inviteLinkParentGroupSubjectV2 = null;
        byte[] inviteLinkParentGroupThumbnailV2 = null;
        it.auties.whatsapp.model.message.standard.TextMessage.InviteLinkGroupType inviteLinkGroupTypeV2 = null;
        boolean viewOnce = false;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> text = inputStream.readString();
                case 2 -> matchedText = inputStream.readString();
                case 4 -> canonicalUrl = inputStream.readString();
                case 5 -> description = inputStream.readString();
                case 6 -> title = inputStream.readString();
                case 7 -> textArgb = inputStream.readFixed32();
                case 8 -> backgroundArgb = inputStream.readFixed32();
                case 9 -> font = it.auties.whatsapp.model.message.standard.TextMessageFontTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 10 -> previewType = it.auties.whatsapp.model.message.standard.TextMessagePreviewTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 16 -> thumbnail = inputStream.readBytes();
                case 17 -> contextInfo = it.auties.whatsapp.model.info.ContextInfoSpec.decode(inputStream.readBytes());
                case 18 -> doNotPlayInline = inputStream.readBool();
                case 19 -> thumbnailDirectPath = inputStream.readString();
                case 20 -> thumbnailSha256 = inputStream.readBytes();
                case 21 -> thumbnailEncSha256 = inputStream.readBytes();
                case 22 -> mediaKey = inputStream.readBytes();
                case 23 -> mediaKeyTimestampSeconds = inputStream.readInt64();
                case 24 -> thumbnailHeight = inputStream.readInt32();
                case 25 -> thumbnailWidth = inputStream.readInt32();
                case 26 -> inviteLinkGroupType = it.auties.whatsapp.model.message.standard.TextMessageInviteLinkGroupTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 27 -> inviteLinkParentGroupSubjectV2 = inputStream.readString();
                case 28 -> inviteLinkParentGroupThumbnailV2 = inputStream.readBytes();
                case 29 -> inviteLinkGroupTypeV2 = it.auties.whatsapp.model.message.standard.TextMessageInviteLinkGroupTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 30 -> viewOnce = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.message.standard.TextMessage(text, matchedText, canonicalUrl, description, title, textArgb, backgroundArgb, font, previewType, thumbnail, contextInfo, doNotPlayInline, thumbnailDirectPath, thumbnailSha256, thumbnailEncSha256, mediaKey, mediaKeyTimestampSeconds, thumbnailHeight, thumbnailWidth, inviteLinkGroupType, inviteLinkParentGroupSubjectV2, inviteLinkParentGroupThumbnailV2, inviteLinkGroupTypeV2, viewOnce);
    }

}
