package it.auties.whatsapp.model.newsletter;

import it.auties.whatsapp.model.newsletter.NewsletterDescription;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class NewsletterDescriptionSpec {
    public static byte[] encode(NewsletterDescription protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.id());
outputStream.writeString(2, protoInputObject.text());
outputStream.writeUInt64(3, protoInputObject.updateTimeSeconds());
      return outputStream.toByteArray();
    }

    public static NewsletterDescription decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String id = null;
        java.lang.String text = null;
        long updateTimeSeconds = 0l;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> id = inputStream.readString();
                case 2 -> text = inputStream.readString();
                case 3 -> updateTimeSeconds = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.newsletter.NewsletterDescription(id, text, updateTimeSeconds);
    }

}
