package it.auties.whatsapp.model.newsletter;

import it.auties.whatsapp.model.newsletter.NewsletterReaction;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class NewsletterReactionSpec {
    public static byte[] encode(NewsletterReaction protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.content());
outputStream.writeUInt64(2, protoInputObject.count());
outputStream.writeBool(3, protoInputObject.fromMe());
      return outputStream.toByteArray();
    }

    public static NewsletterReaction decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String content = null;
        long count = 0l;
        boolean fromMe = false;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> content = inputStream.readString();
                case 2 -> count = inputStream.readInt64();
                case 3 -> fromMe = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.newsletter.NewsletterReaction(content, count, fromMe);
    }

}
