package it.auties.whatsapp.model.poll;

import it.auties.whatsapp.model.poll.PollUpdateEncryptedOptions;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class PollUpdateEncryptedOptionsSpec {
    public static byte[] encode(PollUpdateEncryptedOptions protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
      if(protoInputObject.selectedOptions() != null) {
       for(var selectedOptionsEntry : protoInputObject.selectedOptions()) {
outputStream.writeBytes(1, selectedOptionsEntry);
       }
      }
      return outputStream.toByteArray();
    }

    public static PollUpdateEncryptedOptions decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.util.List<byte[]> selectedOptions = new java.util.ArrayList<byte[]>();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> selectedOptions.add(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.poll.PollUpdateEncryptedOptions(selectedOptions);
    }

}
