package it.auties.whatsapp.model.poll;

import it.auties.whatsapp.model.poll.PollUpdate;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class PollUpdateSpec {
    public static byte[] encode(PollUpdate protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, it.auties.whatsapp.model.message.model.ChatMessageKeySpec.encode(protoInputObject.pollUpdateMessageKey()));
outputStream.writeBytes(2, it.auties.whatsapp.model.poll.PollUpdateEncryptedOptionsSpec.encode(protoInputObject.vote()));
outputStream.writeInt64(3, protoInputObject.senderTimestampMilliseconds());
      return outputStream.toByteArray();
    }

    public static PollUpdate decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.message.model.ChatMessageKey pollUpdateMessageKey = null;
        it.auties.whatsapp.model.poll.PollUpdateEncryptedOptions vote = null;
        long senderTimestampMilliseconds = 0l;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> pollUpdateMessageKey = it.auties.whatsapp.model.message.model.ChatMessageKeySpec.decode(inputStream.readBytes());
                case 2 -> vote = it.auties.whatsapp.model.poll.PollUpdateEncryptedOptionsSpec.decode(inputStream.readBytes());
                case 3 -> senderTimestampMilliseconds = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.poll.PollUpdate(pollUpdateMessageKey, vote, senderTimestampMilliseconds);
    }

}
