package it.auties.whatsapp.model.product;

import it.auties.whatsapp.model.product.ProductSection;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ProductSectionSpec {
    public static byte[] encode(ProductSection protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeString(1, protoInputObject.title());
      if(protoInputObject.products() != null) {
       for(var productsEntry : protoInputObject.products()) {
outputStream.writeBytes(2, it.auties.whatsapp.model.product.ProductSectionEntrySpec.encode(productsEntry));
       }
      }
      return outputStream.toByteArray();
    }

    public static ProductSection decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.String title = null;
        java.util.List<it.auties.whatsapp.model.product.ProductSectionEntry> products = new java.util.ArrayList<it.auties.whatsapp.model.product.ProductSectionEntry>();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> title = inputStream.readString();
                case 2 -> products.add(it.auties.whatsapp.model.product.ProductSectionEntrySpec.decode(inputStream.readBytes()));
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.product.ProductSection(title, products);
    }

}
