package it.auties.whatsapp.model.product;

import it.auties.whatsapp.model.product.Product;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ProductSpec {
    public static byte[] encode(Product protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, it.auties.whatsapp.model.message.standard.ImageMessageSpec.encode(protoInputObject.image()));
outputStream.writeString(2, protoInputObject.id());
outputStream.writeString(3, protoInputObject.title());
outputStream.writeString(4, protoInputObject.description());
outputStream.writeString(5, protoInputObject.currencyCode());
outputStream.writeInt64(6, protoInputObject.priceAmount1000());
outputStream.writeString(7, protoInputObject.retailerId());
outputStream.writeString(8, protoInputObject.url());
outputStream.writeUInt32(9, protoInputObject.productImageCount());
outputStream.writeString(11, protoInputObject.firstImageId());
outputStream.writeInt64(12, protoInputObject.salePriceAmount1000());
      return outputStream.toByteArray();
    }

    public static Product decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.message.standard.ImageMessage image = null;
        java.lang.String id = null;
        java.lang.String title = null;
        java.lang.String description = null;
        java.lang.String currencyCode = null;
        long priceAmount1000 = 0l;
        java.lang.String retailerId = null;
        java.lang.String url = null;
        int productImageCount = 0;
        java.lang.String firstImageId = null;
        long salePriceAmount1000 = 0l;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> image = it.auties.whatsapp.model.message.standard.ImageMessageSpec.decode(inputStream.readBytes());
                case 2 -> id = inputStream.readString();
                case 3 -> title = inputStream.readString();
                case 4 -> description = inputStream.readString();
                case 5 -> currencyCode = inputStream.readString();
                case 6 -> priceAmount1000 = inputStream.readInt64();
                case 7 -> retailerId = inputStream.readString();
                case 8 -> url = inputStream.readString();
                case 9 -> productImageCount = inputStream.readInt32();
                case 11 -> firstImageId = inputStream.readString();
                case 12 -> salePriceAmount1000 = inputStream.readInt64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.product.Product(image, id, title, description, currencyCode, priceAmount1000, retailerId, url, productImageCount, firstImageId, salePriceAmount1000);
    }

}
