package it.auties.whatsapp.model.setting;

import it.auties.whatsapp.model.setting.EphemeralSettings;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class EphemeralSettingsSpec {
    public static byte[] encode(EphemeralSettings protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeFixed32(1, protoInputObject.duration());
outputStream.writeFixed64(2, protoInputObject.timestampSeconds());
      return outputStream.toByteArray();
    }

    public static EphemeralSettings decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        int duration = 0;
        long timestampSeconds = 0l;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> duration = inputStream.readFixed32();
                case 2 -> timestampSeconds = inputStream.readFixed64();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.setting.EphemeralSettings(duration, timestampSeconds);
    }

}
