package it.auties.whatsapp.model.signal.auth;

import it.auties.whatsapp.model.signal.auth.ClientHello;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ClientHelloSpec {
    public static byte[] encode(ClientHello protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, protoInputObject.ephemeral());
outputStream.writeBytes(2, protoInputObject._static());
outputStream.writeBytes(3, protoInputObject.payload());
      return outputStream.toByteArray();
    }

    public static ClientHello decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] ephemeral = null;
        byte[] _static = null;
        byte[] payload = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> ephemeral = inputStream.readBytes();
                case 2 -> _static = inputStream.readBytes();
                case 3 -> payload = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.auth.ClientHello(ephemeral, _static, payload);
    }

}
