package it.auties.whatsapp.model.signal.auth;

import it.auties.whatsapp.model.signal.auth.ClientPayload;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class ClientPayloadSpec {
    public static byte[] encode(ClientPayload protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeUInt64(1, protoInputObject.username());
outputStream.writeBool(3, protoInputObject.passive());
outputStream.writeBytes(5, it.auties.whatsapp.model.signal.auth.UserAgentSpec.encode(protoInputObject.userAgent()));
outputStream.writeBytes(6, it.auties.whatsapp.model.signal.auth.WebInfoSpec.encode(protoInputObject.webInfo()));
outputStream.writeString(7, protoInputObject.pushName());
outputStream.writeFixed32(9, protoInputObject.sessionId());
outputStream.writeBool(10, protoInputObject.shortConnect());
outputStream.writeInt32(12, it.auties.whatsapp.model.signal.auth.ClientPayloadClientPayloadConnectTypeSpec.encode(protoInputObject.connectType()));
outputStream.writeInt32(13, it.auties.whatsapp.model.signal.auth.ClientPayloadClientPayloadConnectReasonSpec.encode(protoInputObject.connectReason()));
      if(protoInputObject.shards() != null) {
       for(var shardsEntry : protoInputObject.shards()) {
outputStream.writeInt32(14, shardsEntry);
       }
      }
outputStream.writeBytes(15, it.auties.whatsapp.model.signal.auth.DNSSourceSpec.encode(protoInputObject.dnsSource()));
outputStream.writeUInt32(16, protoInputObject.connectAttemptCount());
outputStream.writeUInt32(18, protoInputObject.device());
outputStream.writeBytes(19, it.auties.whatsapp.model.signal.auth.CompanionRegistrationDataSpec.encode(protoInputObject.regData()));
outputStream.writeInt32(20, it.auties.whatsapp.model.signal.auth.ClientPayloadClientPayloadProductSpec.encode(protoInputObject.product()));
outputStream.writeBytes(21, protoInputObject.fbCat());
outputStream.writeBytes(22, protoInputObject.fbUserAgent());
outputStream.writeBool(23, protoInputObject.oc());
outputStream.writeInt32(24, protoInputObject.lc());
outputStream.writeInt32(30, it.auties.whatsapp.model.signal.auth.ClientPayloadClientPayloadIOSAppExtensionSpec.encode(protoInputObject.iosAppExtension()));
outputStream.writeUInt64(31, protoInputObject.fbAppId());
outputStream.writeBytes(32, protoInputObject.fbDeviceId());
outputStream.writeBool(33, protoInputObject.pull());
      return outputStream.toByteArray();
    }

    public static ClientPayload decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.Long username = null;
        java.lang.Boolean passive = null;
        it.auties.whatsapp.model.signal.auth.UserAgent userAgent = null;
        it.auties.whatsapp.model.signal.auth.WebInfo webInfo = null;
        java.lang.String pushName = null;
        java.lang.Integer sessionId = null;
        java.lang.Boolean shortConnect = null;
        it.auties.whatsapp.model.signal.auth.ClientPayload.ClientPayloadConnectType connectType = null;
        it.auties.whatsapp.model.signal.auth.ClientPayload.ClientPayloadConnectReason connectReason = null;
        java.util.List<java.lang.Integer> shards = new java.util.ArrayList<java.lang.Integer>();
        it.auties.whatsapp.model.signal.auth.DNSSource dnsSource = null;
        java.lang.Integer connectAttemptCount = null;
        java.lang.Integer device = null;
        it.auties.whatsapp.model.signal.auth.CompanionRegistrationData regData = null;
        it.auties.whatsapp.model.signal.auth.ClientPayload.ClientPayloadProduct product = null;
        byte[] fbCat = null;
        byte[] fbUserAgent = null;
        java.lang.Boolean oc = null;
        java.lang.Integer lc = null;
        it.auties.whatsapp.model.signal.auth.ClientPayload.ClientPayloadIOSAppExtension iosAppExtension = null;
        java.lang.Long fbAppId = null;
        byte[] fbDeviceId = null;
        java.lang.Boolean pull = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> username = inputStream.readInt64();
                case 3 -> passive = inputStream.readBool();
                case 5 -> userAgent = it.auties.whatsapp.model.signal.auth.UserAgentSpec.decode(inputStream.readBytes());
                case 6 -> webInfo = it.auties.whatsapp.model.signal.auth.WebInfoSpec.decode(inputStream.readBytes());
                case 7 -> pushName = inputStream.readString();
                case 9 -> sessionId = inputStream.readFixed32();
                case 10 -> shortConnect = inputStream.readBool();
                case 12 -> connectType = it.auties.whatsapp.model.signal.auth.ClientPayloadClientPayloadConnectTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 13 -> connectReason = it.auties.whatsapp.model.signal.auth.ClientPayloadClientPayloadConnectReasonSpec.decode(inputStream.readInt32()).orElse(null);
                case 14 -> shards.add(inputStream.readInt32());
                case 15 -> dnsSource = it.auties.whatsapp.model.signal.auth.DNSSourceSpec.decode(inputStream.readBytes());
                case 16 -> connectAttemptCount = inputStream.readInt32();
                case 18 -> device = inputStream.readInt32();
                case 19 -> regData = it.auties.whatsapp.model.signal.auth.CompanionRegistrationDataSpec.decode(inputStream.readBytes());
                case 20 -> product = it.auties.whatsapp.model.signal.auth.ClientPayloadClientPayloadProductSpec.decode(inputStream.readInt32()).orElse(null);
                case 21 -> fbCat = inputStream.readBytes();
                case 22 -> fbUserAgent = inputStream.readBytes();
                case 23 -> oc = inputStream.readBool();
                case 24 -> lc = inputStream.readInt32();
                case 30 -> iosAppExtension = it.auties.whatsapp.model.signal.auth.ClientPayloadClientPayloadIOSAppExtensionSpec.decode(inputStream.readInt32()).orElse(null);
                case 31 -> fbAppId = inputStream.readInt64();
                case 32 -> fbDeviceId = inputStream.readBytes();
                case 33 -> pull = inputStream.readBool();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.auth.ClientPayload(username, passive, userAgent, webInfo, pushName, sessionId, shortConnect, connectType, connectReason, shards, dnsSource, connectAttemptCount, device, regData, product, fbCat, fbUserAgent, oc, lc, iosAppExtension, fbAppId, fbDeviceId, pull);
    }

}
