package it.auties.whatsapp.model.signal.auth;

import it.auties.whatsapp.model.signal.auth.Version;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class VersionSpec {
    public static byte[] encode(Version protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeUInt32(1, protoInputObject.primary());
outputStream.writeUInt32(2, protoInputObject.secondary());
outputStream.writeUInt32(3, protoInputObject.tertiary());
outputStream.writeUInt32(4, protoInputObject.quaternary());
outputStream.writeUInt32(5, protoInputObject.quinary());
      return outputStream.toByteArray();
    }

    public static Version decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.Integer primary = null;
        java.lang.Integer secondary = null;
        java.lang.Integer tertiary = null;
        java.lang.Integer quaternary = null;
        java.lang.Integer quinary = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> primary = inputStream.readInt32();
                case 2 -> secondary = inputStream.readInt32();
                case 3 -> tertiary = inputStream.readInt32();
                case 4 -> quaternary = inputStream.readInt32();
                case 5 -> quinary = inputStream.readInt32();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.auth.Version(primary, secondary, tertiary, quaternary, quinary);
    }

}
