package it.auties.whatsapp.model.signal.keypair;

import it.auties.whatsapp.model.signal.keypair.SignalSignedKeyPair;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class SignalSignedKeyPairSpec {
    public static byte[] encode(SignalSignedKeyPair protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt32(1, protoInputObject.id());
outputStream.writeBytes(2, it.auties.whatsapp.model.signal.keypair.SignalKeyPairSpec.encode(protoInputObject.keyPair()));
outputStream.writeBytes(3, protoInputObject.signature());
      return outputStream.toByteArray();
    }

    public static SignalSignedKeyPair decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        int id = 0;
        it.auties.whatsapp.model.signal.keypair.SignalKeyPair keyPair = null;
        byte[] signature = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> id = inputStream.readInt32();
                case 2 -> keyPair = it.auties.whatsapp.model.signal.keypair.SignalKeyPairSpec.decode(inputStream.readBytes());
                case 3 -> signature = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.keypair.SignalSignedKeyPair(id, keyPair, signature);
    }

}
