package it.auties.whatsapp.model.signal.sender;

import it.auties.whatsapp.model.signal.sender.SenderChainKey;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class SenderChainKeySpec {
    public static byte[] encode(SenderChainKey protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt32(1, protoInputObject.iteration());
outputStream.writeBytes(2, protoInputObject.seed());
      return outputStream.toByteArray();
    }

    public static SenderChainKey decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        int iteration = 0;
        byte[] seed = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> iteration = inputStream.readInt32();
                case 2 -> seed = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.sender.SenderChainKey(iteration, seed);
    }

}
