package it.auties.whatsapp.model.signal.sender;

import it.auties.whatsapp.model.signal.sender.SenderMessageKey;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class SenderMessageKeySpec {
    public static byte[] encode(SenderMessageKey protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt32(1, protoInputObject.iteration());
outputStream.writeBytes(2, protoInputObject.seed());
outputStream.writeBytes(3, protoInputObject.iv());
outputStream.writeBytes(4, protoInputObject.cipherKey());
      return outputStream.toByteArray();
    }

    public static SenderMessageKey decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        int iteration = 0;
        byte[] seed = null;
        byte[] iv = null;
        byte[] cipherKey = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> iteration = inputStream.readInt32();
                case 2 -> seed = inputStream.readBytes();
                case 3 -> iv = inputStream.readBytes();
                case 4 -> cipherKey = inputStream.readBytes();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.sender.SenderMessageKey(iteration, seed, iv, cipherKey);
    }

}
