package it.auties.whatsapp.model.signal.session;

import it.auties.whatsapp.model.signal.session.SessionPreKey;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class SessionPreKeySpec {
    public static byte[] encode(SessionPreKey protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt32(1, protoInputObject.preKeyId());
outputStream.writeBytes(2, protoInputObject.baseKey());
outputStream.writeInt32(3, protoInputObject.signedKeyId());
      return outputStream.toByteArray();
    }

    public static SessionPreKey decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.Integer preKeyId = null;
        byte[] baseKey = null;
        int signedKeyId = 0;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> preKeyId = inputStream.readInt32();
                case 2 -> baseKey = inputStream.readBytes();
                case 3 -> signedKeyId = inputStream.readInt32();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.signal.session.SessionPreKey(preKeyId, baseKey, signedKeyId);
    }

}
