package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.AppStateSyncKeyFingerprint;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class AppStateSyncKeyFingerprintSpec {
    public static byte[] encode(AppStateSyncKeyFingerprint protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeUInt32(1, protoInputObject.rawId());
outputStream.writeUInt32(2, protoInputObject.currentIndex());
      if(protoInputObject.deviceIndexes() != null) {
       for(var deviceIndexesEntry : protoInputObject.deviceIndexes()) {
outputStream.writeUInt32(3, deviceIndexesEntry);
       }
      }
      return outputStream.toByteArray();
    }

    public static AppStateSyncKeyFingerprint decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        java.lang.Integer rawId = null;
        java.lang.Integer currentIndex = null;
        java.util.List<java.lang.Integer> deviceIndexes = new java.util.ArrayList<java.lang.Integer>();
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> rawId = inputStream.readInt32();
                case 2 -> currentIndex = inputStream.readInt32();
                case 3 -> deviceIndexes.addAll(inputStream.readInt32Packed());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.AppStateSyncKeyFingerprint(rawId, currentIndex, deviceIndexes);
    }

}
