package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.HistorySyncNotification;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class HistorySyncNotificationSpec {
    public static byte[] encode(HistorySyncNotification protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
var mediaSha256 = protoInputObject.mediaSha256();
if(mediaSha256 != null) {
var mediaSha2560 = mediaSha256.orElse(null);
if(mediaSha2560 != null) {
outputStream.writeBytes(1, mediaSha2560);
}
}
var mediaSize = protoInputObject.mediaSize();
if(mediaSize != null) {
var mediaSize0 = it.auties.protobuf.extension.OptionalExtension.toNullableLong(mediaSize);
if(mediaSize0 != null) {
outputStream.writeUInt64(2, mediaSize0);
}
}
var mediaKey = protoInputObject.mediaKey();
if(mediaKey != null) {
var mediaKey0 = mediaKey.orElse(null);
if(mediaKey0 != null) {
outputStream.writeBytes(3, mediaKey0);
}
}
var mediaEncryptedSha256 = protoInputObject.mediaEncryptedSha256();
if(mediaEncryptedSha256 != null) {
var mediaEncryptedSha2560 = mediaEncryptedSha256.orElse(null);
if(mediaEncryptedSha2560 != null) {
outputStream.writeBytes(4, mediaEncryptedSha2560);
}
}
var mediaDirectPath = protoInputObject.mediaDirectPath();
if(mediaDirectPath != null) {
var mediaDirectPath0 = mediaDirectPath.orElse(null);
if(mediaDirectPath0 != null) {
outputStream.writeString(5, mediaDirectPath0);
}
}
outputStream.writeInt32(6, it.auties.whatsapp.model.sync.HistorySyncTypeSpec.encode(protoInputObject.syncType()));
outputStream.writeUInt32(7, protoInputObject.chunkOrder());
var originalMessageId = protoInputObject.originalMessageId();
if(originalMessageId != null) {
var originalMessageId0 = originalMessageId.orElse(null);
if(originalMessageId0 != null) {
outputStream.writeString(8, originalMessageId0);
}
}
outputStream.writeUInt32(9, protoInputObject.progress());
outputStream.writeInt64(10, protoInputObject.oldestMsgInChunkTimestampSec());
var initialHistBootstrapInlinePayload = protoInputObject.initialHistBootstrapInlinePayload();
if(initialHistBootstrapInlinePayload != null) {
var initialHistBootstrapInlinePayload0 = initialHistBootstrapInlinePayload.orElse(null);
if(initialHistBootstrapInlinePayload0 != null) {
outputStream.writeBytes(11, initialHistBootstrapInlinePayload0);
}
}
var peerDataRequestSessionId = protoInputObject.peerDataRequestSessionId();
if(peerDataRequestSessionId != null) {
var peerDataRequestSessionId0 = peerDataRequestSessionId.orElse(null);
if(peerDataRequestSessionId0 != null) {
outputStream.writeString(12, peerDataRequestSessionId0);
}
}
      return outputStream.toByteArray();
    }

    public static HistorySyncNotification decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        byte[] mediaSha256 = null;
        java.lang.Long mediaSize = null;
        byte[] mediaKey = null;
        byte[] mediaEncryptedSha256 = null;
        java.lang.String mediaDirectPath = null;
        it.auties.whatsapp.model.sync.HistorySync.Type syncType = null;
        java.lang.Integer chunkOrder = null;
        java.lang.String originalMessageId = null;
        int progress = 0;
        long oldestMsgInChunkTimestampSec = 0l;
        byte[] initialHistBootstrapInlinePayload = null;
        java.lang.String peerDataRequestSessionId = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> mediaSha256 = inputStream.readBytes();
                case 2 -> mediaSize = inputStream.readInt64();
                case 3 -> mediaKey = inputStream.readBytes();
                case 4 -> mediaEncryptedSha256 = inputStream.readBytes();
                case 5 -> mediaDirectPath = inputStream.readString();
                case 6 -> syncType = it.auties.whatsapp.model.sync.HistorySyncTypeSpec.decode(inputStream.readInt32()).orElse(null);
                case 7 -> chunkOrder = inputStream.readInt32();
                case 8 -> originalMessageId = inputStream.readString();
                case 9 -> progress = inputStream.readInt32();
                case 10 -> oldestMsgInChunkTimestampSec = inputStream.readInt64();
                case 11 -> initialHistBootstrapInlinePayload = inputStream.readBytes();
                case 12 -> peerDataRequestSessionId = inputStream.readString();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.HistorySyncNotification(mediaSha256, mediaSize, mediaKey, mediaEncryptedSha256, mediaDirectPath, syncType, chunkOrder, originalMessageId, progress, oldestMsgInChunkTimestampSec, initialHistBootstrapInlinePayload, peerDataRequestSessionId);
    }

}
