package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.MutationSync;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class MutationSyncSpec {
    public static byte[] encode(MutationSync protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeInt32(1, it.auties.whatsapp.model.sync.RecordSyncOperationSpec.encode(protoInputObject.operation()));
outputStream.writeBytes(2, it.auties.whatsapp.model.sync.RecordSyncSpec.encode(protoInputObject.record()));
      return outputStream.toByteArray();
    }

    public static MutationSync decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.sync.RecordSync.Operation operation = null;
        it.auties.whatsapp.model.sync.RecordSync record = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> operation = it.auties.whatsapp.model.sync.RecordSyncOperationSpec.decode(inputStream.readInt32()).orElse(null);
                case 2 -> record = it.auties.whatsapp.model.sync.RecordSyncSpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.MutationSync(operation, record);
    }

}
