package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.PatchSync;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class PatchSyncSpec {
    public static byte[] encode(PatchSync protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, it.auties.whatsapp.model.sync.VersionSyncSpec.encode(protoInputObject.version()));
      if(protoInputObject.mutations() != null) {
       for(var mutationsEntry : protoInputObject.mutations()) {
outputStream.writeBytes(2, it.auties.whatsapp.model.sync.MutationSyncSpec.encode(mutationsEntry));
       }
      }
outputStream.writeBytes(3, it.auties.whatsapp.model.sync.ExternalBlobReferenceSpec.encode(protoInputObject.externalMutations()));
outputStream.writeBytes(4, protoInputObject.snapshotMac());
outputStream.writeBytes(5, protoInputObject.patchMac());
outputStream.writeBytes(6, it.auties.whatsapp.model.sync.KeyIdSpec.encode(protoInputObject.keyId()));
outputStream.writeBytes(7, it.auties.whatsapp.model.sync.ExitCodeSpec.encode(protoInputObject.exitCode()));
outputStream.writeUInt32(8, protoInputObject.deviceIndex());
      return outputStream.toByteArray();
    }

    public static PatchSync decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.sync.VersionSync version = null;
        java.util.List<it.auties.whatsapp.model.sync.MutationSync> mutations = new java.util.ArrayList<it.auties.whatsapp.model.sync.MutationSync>();
        it.auties.whatsapp.model.sync.ExternalBlobReference externalMutations = null;
        byte[] snapshotMac = null;
        byte[] patchMac = null;
        it.auties.whatsapp.model.sync.KeyId keyId = null;
        it.auties.whatsapp.model.sync.ExitCode exitCode = null;
        java.lang.Integer deviceIndex = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> version = it.auties.whatsapp.model.sync.VersionSyncSpec.decode(inputStream.readBytes());
                case 2 -> mutations.add(it.auties.whatsapp.model.sync.MutationSyncSpec.decode(inputStream.readBytes()));
                case 3 -> externalMutations = it.auties.whatsapp.model.sync.ExternalBlobReferenceSpec.decode(inputStream.readBytes());
                case 4 -> snapshotMac = inputStream.readBytes();
                case 5 -> patchMac = inputStream.readBytes();
                case 6 -> keyId = it.auties.whatsapp.model.sync.KeyIdSpec.decode(inputStream.readBytes());
                case 7 -> exitCode = it.auties.whatsapp.model.sync.ExitCodeSpec.decode(inputStream.readBytes());
                case 8 -> deviceIndex = inputStream.readInt32();
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.PatchSync(version, mutations, externalMutations, snapshotMac, patchMac, keyId, exitCode, deviceIndex);
    }

}
