package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.sync.SnapshotSync;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;

public class SnapshotSyncSpec {
    public static byte[] encode(SnapshotSync protoInputObject) {
      if(protoInputObject == null) {
         return null;
      }
      var outputStream = new ProtobufOutputStream();
outputStream.writeBytes(1, it.auties.whatsapp.model.sync.VersionSyncSpec.encode(protoInputObject.version()));
      if(protoInputObject.records() != null) {
       for(var recordsEntry : protoInputObject.records()) {
outputStream.writeBytes(2, it.auties.whatsapp.model.sync.RecordSyncSpec.encode(recordsEntry));
       }
      }
outputStream.writeBytes(3, protoInputObject.mac());
outputStream.writeBytes(4, it.auties.whatsapp.model.sync.KeyIdSpec.encode(protoInputObject.keyId()));
      return outputStream.toByteArray();
    }

    public static SnapshotSync decode(byte[] input) {
        if(input == null) {
            return null;
        }
        var inputStream = new ProtobufInputStream(input);
        it.auties.whatsapp.model.sync.VersionSync version = null;
        java.util.List<it.auties.whatsapp.model.sync.RecordSync> records = new java.util.ArrayList<it.auties.whatsapp.model.sync.RecordSync>();
        byte[] mac = null;
        it.auties.whatsapp.model.sync.KeyId keyId = null;
        while(inputStream.readTag()) {
            switch(inputStream.index()) {
                case 1 -> version = it.auties.whatsapp.model.sync.VersionSyncSpec.decode(inputStream.readBytes());
                case 2 -> records.add(it.auties.whatsapp.model.sync.RecordSyncSpec.decode(inputStream.readBytes()));
                case 3 -> mac = inputStream.readBytes();
                case 4 -> keyId = it.auties.whatsapp.model.sync.KeyIdSpec.decode(inputStream.readBytes());
                default -> inputStream.skipBytes();
            }
        }
        return new it.auties.whatsapp.model.sync.SnapshotSync(version, records, mac, keyId);
    }

}
