/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.api;

import it.auties.whatsapp.api.ErrorHandler;
import it.auties.whatsapp.api.MobileOptionsBuilder;
import it.auties.whatsapp.api.TextPreviewSetting;
import it.auties.whatsapp.api.WebOptionsBuilder;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.auth.Version;
import java.net.URI;
import java.util.concurrent.ExecutorService;

public sealed class OptionsBuilder<T extends OptionsBuilder<T>>
permits MobileOptionsBuilder, WebOptionsBuilder {
    Store store;
    Keys keys;
    ErrorHandler errorHandler;
    ExecutorService socketExecutor;

    OptionsBuilder(Store store, Keys keys) {
        this.store = store;
        this.keys = keys;
    }

    public T name(String name) {
        this.store.setName(name);
        return (T)this;
    }

    public T version(Version version) {
        this.store.setVersion(version);
        return (T)this;
    }

    public T autodetectListeners(boolean autodetectListeners) {
        this.store.setAutodetectListeners(autodetectListeners);
        return (T)this;
    }

    public T textPreviewSetting(TextPreviewSetting textPreviewSetting) {
        this.store.setTextPreviewSetting(textPreviewSetting);
        return (T)this;
    }

    public T errorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return (T)this;
    }

    public T socketExecutor(ExecutorService socketExecutor) {
        this.socketExecutor = socketExecutor;
        return (T)this;
    }

    public T releaseChannel(UserAgent.ReleaseChannel releaseChannel) {
        this.store.setReleaseChannel(releaseChannel);
        return (T)this;
    }

    public T proxy(URI proxy) {
        this.store.setProxy(proxy);
        return (T)this;
    }

    public T automaticPresenceUpdates(boolean automaticPresenceUpdates) {
        this.store.setAutomaticPresenceUpdates(automaticPresenceUpdates);
        return (T)this;
    }

    public T checkPatchMacks(boolean checkPatchMacs) {
        this.store.setCheckPatchMacs(checkPatchMacs);
        return (T)this;
    }
}

