/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.api;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import it.auties.qr.QrTerminal;
import it.auties.whatsapp.api.WebVerificationSupport;
import java.awt.Desktop;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.function.Consumer;

@FunctionalInterface
public non-sealed interface QrHandler
extends Consumer<String>,
WebVerificationSupport {
    public static QrHandler toTerminal() {
        return QrHandler.toString(System.out::println);
    }

    public static QrHandler toString(Consumer<String> smallQrConsumer) {
        return qr -> {
            BitMatrix matrix = QrHandler.createMatrix(qr, 10, 0);
            smallQrConsumer.accept(QrTerminal.toString((BitMatrix)matrix, (boolean)true));
        };
    }

    public static QrHandler toPlainString(Consumer<String> qrConsumer) {
        return qrConsumer::accept;
    }

    public static BitMatrix createMatrix(String qr, int size, int margin) {
        try {
            MultiFormatWriter writer = new MultiFormatWriter();
            return writer.encode(qr, BarcodeFormat.QR_CODE, size, size, Map.of(EncodeHintType.MARGIN, margin, EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L));
        }
        catch (WriterException exception) {
            throw new UnsupportedOperationException("Cannot create qr countryCode", exception);
        }
    }

    public static QrHandler toFile(ToFileConsumer fileConsumer) {
        try {
            Path file = Files.createTempFile("qr", ".jpg", new FileAttribute[0]);
            return QrHandler.toFile(file, fileConsumer);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot create temp file for qr handler", exception);
        }
    }

    public static QrHandler toFile(Path path, ToFileConsumer fileConsumer) {
        return qr -> {
            try {
                BitMatrix matrix = QrHandler.createMatrix(qr, 500, 5);
                MatrixToImageWriter.writeToPath((BitMatrix)matrix, (String)"jpg", (Path)path);
                fileConsumer.accept(path);
            }
            catch (IOException exception) {
                throw new UncheckedIOException("Cannot save qr to file", exception);
            }
        };
    }

    public static interface ToFileConsumer
    extends Consumer<Path> {
        public static ToFileConsumer discarding() {
            return ignored -> {};
        }

        public static ToFileConsumer toTerminal() {
            return path -> System.getLogger(QrHandler.class.getName()).log(System.Logger.Level.INFO, "Saved qr code at %s".formatted(path));
        }

        public static ToFileConsumer toDesktop() {
            return path -> {
                try {
                    if (!Desktop.isDesktopSupported()) {
                        return;
                    }
                    Desktop.getDesktop().open(path.toFile());
                }
                catch (IOException exception) {
                    throw new UncheckedIOException("Cannot open file with desktop", exception);
                }
            };
        }
    }
}

