/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.api;

import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.ErrorHandler;
import it.auties.whatsapp.api.QrHandler;
import it.auties.whatsapp.api.WebVerificationSupport;
import it.auties.whatsapp.api.Whatsapp;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.util.Validate;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

public class WhatsappCustomBuilder {
    private Store store;
    private Keys keys;
    private ErrorHandler errorHandler;
    private WebVerificationSupport webVerificationSupport;
    private ExecutorService socketExecutor;

    WhatsappCustomBuilder() {
    }

    public WhatsappCustomBuilder store(Store store) {
        this.store = store;
        return this;
    }

    public WhatsappCustomBuilder keys(Keys keys) {
        this.keys = keys;
        return this;
    }

    public WhatsappCustomBuilder errorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public WhatsappCustomBuilder webVerificationSupport(WebVerificationSupport webVerificationSupport) {
        this.webVerificationSupport = webVerificationSupport;
        return this;
    }

    public WhatsappCustomBuilder socketExecutor(ExecutorService socketExecutor) {
        this.socketExecutor = socketExecutor;
        return this;
    }

    public Whatsapp build() {
        Validate.isTrue(Objects.equals(this.store.uuid(), this.keys.uuid()), "UUID mismatch: %s != %s", this.store.uuid(), this.keys.uuid());
        Optional<Whatsapp> knownInstance = Whatsapp.getInstanceByUuid(this.store.uuid());
        if (knownInstance.isPresent()) {
            return knownInstance.get();
        }
        WebVerificationSupport checkedSupport = WhatsappCustomBuilder.getWebVerificationMethod(this.store, this.keys, this.webVerificationSupport);
        return new Whatsapp(this.store, this.keys, this.errorHandler, checkedSupport, this.socketExecutor);
    }

    private static WebVerificationSupport getWebVerificationMethod(Store store, Keys keys, WebVerificationSupport webVerificationSupport) {
        if (store.clientType() != ClientType.WEB) {
            return null;
        }
        if (!keys.registered() && webVerificationSupport == null) {
            return QrHandler.toTerminal();
        }
        return webVerificationSupport;
    }
}

