/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.controller;

import com.fasterxml.jackson.annotation.JsonIgnore;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufMessage;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.controller.ControllerSerializer;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.util.Json;
import it.auties.whatsapp.util.ProtobufUuidMixin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public abstract sealed class Controller<T extends Controller<T>>
implements ProtobufMessage
permits Store, Keys {
    @ProtobufProperty(index=1, type=ProtobufType.STRING, mixin=ProtobufUuidMixin.class)
    protected final UUID uuid;
    @ProtobufProperty(index=2, type=ProtobufType.UINT64)
    private PhoneNumber phoneNumber;
    @JsonIgnore
    protected ControllerSerializer serializer;
    @ProtobufProperty(index=3, type=ProtobufType.OBJECT)
    protected final ClientType clientType;
    @ProtobufProperty(index=4, type=ProtobufType.STRING)
    protected final Collection<String> alias;

    public Controller(UUID uuid, PhoneNumber phoneNumber, ControllerSerializer serializer, ClientType clientType, Collection<String> alias) {
        this.uuid = uuid;
        this.phoneNumber = phoneNumber;
        this.serializer = serializer;
        this.clientType = clientType;
        this.alias = Objects.requireNonNullElseGet(alias, ArrayList::new);
    }

    public abstract void serialize(boolean var1);

    public abstract void dispose();

    public UUID uuid() {
        return this.uuid;
    }

    public ClientType clientType() {
        return this.clientType;
    }

    public Optional<PhoneNumber> phoneNumber() {
        return Optional.ofNullable(this.phoneNumber);
    }

    public T setPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
        this.serializer.linkMetadata(this);
        return (T)this;
    }

    public ControllerSerializer serializer() {
        return this.serializer;
    }

    public T setSerializer(ControllerSerializer serializer) {
        this.serializer = serializer;
        return (T)this;
    }

    public Collection<String> alias() {
        return Collections.unmodifiableCollection(this.alias);
    }

    public void addAlias(String entry) {
        this.alias.add(entry);
    }

    public void removeAlias(String entry) {
        this.alias.remove(entry);
    }

    public void removeAlias() {
        this.alias.clear();
    }

    public String toJson() {
        return Json.writeValueAsString(this, true);
    }

    public void deleteSession() {
        this.serializer.deleteSession(this);
    }
}

