/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.controller;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.ClientTypeSpec;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.model.companion.CompanionPatch;
import it.auties.whatsapp.model.companion.CompanionPatchSpec;
import it.auties.whatsapp.model.companion.CompanionSyncKey;
import it.auties.whatsapp.model.companion.CompanionSyncKeySpec;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentity;
import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentitySpec;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPairSpec;
import it.auties.whatsapp.model.signal.keypair.SignalPreKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalPreKeyPairSpec;
import it.auties.whatsapp.model.signal.keypair.SignalSignedKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalSignedKeyPairSpec;
import it.auties.whatsapp.model.signal.sender.SenderKeyName;
import it.auties.whatsapp.model.signal.sender.SenderKeyRecord;
import it.auties.whatsapp.model.signal.sender.SenderKeyRecordSpec;
import it.auties.whatsapp.model.signal.sender.SenderPreKeys;
import it.auties.whatsapp.model.signal.sender.SenderPreKeysSpec;
import it.auties.whatsapp.model.signal.session.Session;
import it.auties.whatsapp.model.signal.session.SessionAddress;
import it.auties.whatsapp.model.signal.session.SessionSpec;
import it.auties.whatsapp.util.ProtobufUuidMixin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class KeysSpec {
    public static byte[] encode(Keys protoInputObject) {
        PhoneNumber phoneNumber0;
        Optional<PhoneNumber> phoneNumber;
        String uuid0;
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        UUID uuid = protoInputObject.uuid;
        if (uuid != null && (uuid0 = ProtobufUuidMixin.toValue(uuid)) != null) {
            outputStream.writeString(1, uuid0);
        }
        if ((phoneNumber = protoInputObject.phoneNumber()) != null && (phoneNumber0 = (PhoneNumber)phoneNumber.orElse(null)) != null) {
            long l = phoneNumber0.number();
            outputStream.writeUInt64(2, Long.valueOf(l));
        }
        outputStream.writeInt32(3, ClientTypeSpec.encode(protoInputObject.clientType));
        if (protoInputObject.alias != null) {
            for (String string : protoInputObject.alias) {
                outputStream.writeString(4, string);
            }
        }
        outputStream.writeInt32(5, Integer.valueOf(protoInputObject.registrationId));
        outputStream.writeBytes(6, SignalKeyPairSpec.encode(protoInputObject.noiseKeyPair));
        outputStream.writeBytes(7, SignalKeyPairSpec.encode(protoInputObject.ephemeralKeyPair));
        outputStream.writeBytes(8, SignalKeyPairSpec.encode(protoInputObject.identityKeyPair));
        outputStream.writeBytes(9, SignalKeyPairSpec.encode(protoInputObject.companionKeyPair));
        outputStream.writeBytes(10, SignalSignedKeyPairSpec.encode(protoInputObject.signedKeyPair));
        outputStream.writeBytes(11, protoInputObject.signedKeyIndex);
        outputStream.writeUInt64(12, protoInputObject.signedKeyIndexTimestamp);
        if (protoInputObject.preKeys != null) {
            for (SignalPreKeyPair signalPreKeyPair : protoInputObject.preKeys) {
                outputStream.writeBytes(13, SignalPreKeyPairSpec.encode(signalPreKeyPair));
            }
        }
        outputStream.writeString(14, protoInputObject.phoneId);
        outputStream.writeBytes(15, protoInputObject.deviceId);
        outputStream.writeBytes(16, protoInputObject.identityId);
        outputStream.writeBytes(17, SignedDeviceIdentitySpec.encode(protoInputObject.companionIdentity));
        if (protoInputObject.senderKeys != null) {
            for (Map.Entry entry : protoInputObject.senderKeys.entrySet()) {
                String senderKeys0;
                ProtobufOutputStream senderKeysOutputStream = new ProtobufOutputStream();
                SenderKeyName senderKeys = (SenderKeyName)entry.getKey();
                if (senderKeys != null && (senderKeys0 = senderKeys.toString()) != null) {
                    senderKeysOutputStream.writeString(1, senderKeys0);
                }
                senderKeysOutputStream.writeBytes(2, SenderKeyRecordSpec.encode((SenderKeyRecord)entry.getValue()));
                outputStream.writeBytes(18, senderKeysOutputStream.toByteArray());
            }
        }
        if (protoInputObject.appStateKeys != null) {
            for (CompanionSyncKey companionSyncKey : protoInputObject.appStateKeys) {
                outputStream.writeBytes(19, CompanionSyncKeySpec.encode(companionSyncKey));
            }
        }
        if (protoInputObject.sessions != null) {
            for (Map.Entry entry : protoInputObject.sessions.entrySet()) {
                String sessions0;
                ProtobufOutputStream sessionsOutputStream = new ProtobufOutputStream();
                SessionAddress sessions = (SessionAddress)entry.getKey();
                if (sessions != null && (sessions0 = sessions.toString()) != null) {
                    sessionsOutputStream.writeString(1, sessions0);
                }
                sessionsOutputStream.writeBytes(2, SessionSpec.encode((Session)entry.getValue()));
                outputStream.writeBytes(20, sessionsOutputStream.toByteArray());
            }
        }
        if (protoInputObject.hashStates != null) {
            for (CompanionPatch companionPatch : protoInputObject.hashStates) {
                outputStream.writeBytes(21, CompanionPatchSpec.encode(companionPatch));
            }
        }
        if (protoInputObject.groupsPreKeys != null) {
            for (Map.Entry entry : protoInputObject.groupsPreKeys.entrySet()) {
                String groupsPreKeys0;
                ProtobufOutputStream groupsPreKeysOutputStream = new ProtobufOutputStream();
                Jid groupsPreKeys = (Jid)entry.getKey();
                if (groupsPreKeys != null && (groupsPreKeys0 = groupsPreKeys.toProtobufValue()) != null) {
                    groupsPreKeysOutputStream.writeString(1, groupsPreKeys0);
                }
                groupsPreKeysOutputStream.writeBytes(2, SenderPreKeysSpec.encode((SenderPreKeys)entry.getValue()));
                outputStream.writeBytes(22, groupsPreKeysOutputStream.toByteArray());
            }
        }
        outputStream.writeBool(23, Boolean.valueOf(protoInputObject.registered));
        outputStream.writeBool(24, Boolean.valueOf(protoInputObject.businessCertificate));
        outputStream.writeBool(25, Boolean.valueOf(protoInputObject.initialAppSync));
        return outputStream.toByteArray();
    }

    public static Keys decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        UUID uuid = null;
        PhoneNumber phoneNumber = null;
        ClientType clientType = null;
        ArrayList<String> alias = new ArrayList<String>();
        int registrationId = 0;
        SignalKeyPair noiseKeyPair = null;
        SignalKeyPair ephemeralKeyPair = null;
        SignalKeyPair identityKeyPair = null;
        SignalKeyPair companionKeyPair = null;
        SignalSignedKeyPair signedKeyPair = null;
        byte[] signedKeyIndex = null;
        Long signedKeyIndexTimestamp = null;
        ArrayList<SignalPreKeyPair> preKeys = new ArrayList<SignalPreKeyPair>();
        String phoneId = null;
        byte[] deviceId = null;
        byte[] identityId = null;
        SignedDeviceIdentity companionIdentity = null;
        HashMap<SenderKeyName, SenderKeyRecord> senderKeys = new HashMap<SenderKeyName, SenderKeyRecord>();
        ArrayList<CompanionSyncKey> appStateKeys = new ArrayList<CompanionSyncKey>();
        HashMap<SessionAddress, Session> sessions = new HashMap<SessionAddress, Session>();
        ArrayList<CompanionPatch> hashStates = new ArrayList<CompanionPatch>();
        HashMap<Jid, SenderPreKeys> groupsPreKeys = new HashMap<Jid, SenderPreKeys>();
        boolean registered = false;
        boolean businessCertificate = false;
        boolean initialAppSync = false;
        block39: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    uuid = ProtobufUuidMixin.of(inputStream.readString());
                    continue block39;
                }
                case 2: {
                    phoneNumber = PhoneNumber.of(inputStream.readInt64());
                    continue block39;
                }
                case 3: {
                    clientType = ClientTypeSpec.decode(inputStream.readInt32()).orElse(null);
                    continue block39;
                }
                case 4: {
                    alias.add(inputStream.readString());
                    continue block39;
                }
                case 5: {
                    registrationId = inputStream.readInt32();
                    continue block39;
                }
                case 6: {
                    noiseKeyPair = SignalKeyPairSpec.decode(inputStream.readBytes());
                    continue block39;
                }
                case 7: {
                    ephemeralKeyPair = SignalKeyPairSpec.decode(inputStream.readBytes());
                    continue block39;
                }
                case 8: {
                    identityKeyPair = SignalKeyPairSpec.decode(inputStream.readBytes());
                    continue block39;
                }
                case 9: {
                    companionKeyPair = SignalKeyPairSpec.decode(inputStream.readBytes());
                    continue block39;
                }
                case 10: {
                    signedKeyPair = SignalSignedKeyPairSpec.decode(inputStream.readBytes());
                    continue block39;
                }
                case 11: {
                    signedKeyIndex = inputStream.readBytes();
                    continue block39;
                }
                case 12: {
                    signedKeyIndexTimestamp = inputStream.readInt64();
                    continue block39;
                }
                case 13: {
                    preKeys.add(SignalPreKeyPairSpec.decode(inputStream.readBytes()));
                    continue block39;
                }
                case 14: {
                    phoneId = inputStream.readString();
                    continue block39;
                }
                case 15: {
                    deviceId = inputStream.readBytes();
                    continue block39;
                }
                case 16: {
                    identityId = inputStream.readBytes();
                    continue block39;
                }
                case 17: {
                    companionIdentity = SignedDeviceIdentitySpec.decode(inputStream.readBytes());
                    continue block39;
                }
                case 18: {
                    ProtobufInputStream senderKeysInputStream = new ProtobufInputStream(inputStream.readBytes());
                    SenderKeyName senderKeysKey = null;
                    SenderKeyRecord senderKeysValue = null;
                    while (senderKeysInputStream.readTag()) {
                        switch (senderKeysInputStream.index()) {
                            case 1: {
                                senderKeysKey = SenderKeyName.of(senderKeysInputStream.readString());
                                break;
                            }
                            case 2: {
                                senderKeysValue = SenderKeyRecordSpec.decode(senderKeysInputStream.readBytes());
                            }
                        }
                    }
                    senderKeys.put(senderKeysKey, senderKeysValue);
                    continue block39;
                }
                case 19: {
                    appStateKeys.add(CompanionSyncKeySpec.decode(inputStream.readBytes()));
                    continue block39;
                }
                case 20: {
                    ProtobufInputStream sessionsInputStream = new ProtobufInputStream(inputStream.readBytes());
                    SessionAddress sessionsKey = null;
                    Session sessionsValue = null;
                    while (sessionsInputStream.readTag()) {
                        switch (sessionsInputStream.index()) {
                            case 1: {
                                sessionsKey = SessionAddress.of(sessionsInputStream.readString());
                                break;
                            }
                            case 2: {
                                sessionsValue = SessionSpec.decode(sessionsInputStream.readBytes());
                            }
                        }
                    }
                    sessions.put(sessionsKey, sessionsValue);
                    continue block39;
                }
                case 21: {
                    hashStates.add(CompanionPatchSpec.decode(inputStream.readBytes()));
                    continue block39;
                }
                case 22: {
                    ProtobufInputStream groupsPreKeysInputStream = new ProtobufInputStream(inputStream.readBytes());
                    Jid groupsPreKeysKey = null;
                    SenderPreKeys groupsPreKeysValue = null;
                    while (groupsPreKeysInputStream.readTag()) {
                        switch (groupsPreKeysInputStream.index()) {
                            case 1: {
                                groupsPreKeysKey = Jid.ofProtobuf(groupsPreKeysInputStream.readString());
                                break;
                            }
                            case 2: {
                                groupsPreKeysValue = SenderPreKeysSpec.decode(groupsPreKeysInputStream.readBytes());
                            }
                        }
                    }
                    groupsPreKeys.put(groupsPreKeysKey, groupsPreKeysValue);
                    continue block39;
                }
                case 23: {
                    registered = inputStream.readBool();
                    continue block39;
                }
                case 24: {
                    businessCertificate = inputStream.readBool();
                    continue block39;
                }
                case 25: {
                    initialAppSync = inputStream.readBool();
                    continue block39;
                }
            }
            inputStream.skipBytes();
        }
        return new Keys(uuid, phoneNumber, clientType, alias, registrationId, noiseKeyPair, ephemeralKeyPair, identityKeyPair, companionKeyPair, signedKeyPair, signedKeyIndex, signedKeyIndexTimestamp, preKeys, phoneId, deviceId, identityId, companionIdentity, senderKeys, appStateKeys, sessions, hashStates, groupsPreKeys, registered, businessCertificate, initialAppSync);
    }
}

