/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.crypto;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;

public final class AesGcm {
    private static final int NONCE = 128;

    private AesGcm() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static byte[] encrypt(long iv, byte[] input, byte[] key) {
        return AesGcm.encrypt(iv, input, key, null);
    }

    public static byte[] encrypt(long iv, byte[] input, byte[] key, byte[] additionalData) {
        return AesGcm.cipher(AesGcm.toIv(iv), input, key, additionalData, true);
    }

    private static byte[] cipher(byte[] iv, byte[] input, byte[] key, byte[] additionalData, boolean encrypt) {
        try {
            GCMBlockCipher cipher = new GCMBlockCipher((BlockCipher)new AESEngine());
            AEADParameters parameters = new AEADParameters(new KeyParameter(key), 128, iv, additionalData);
            cipher.init(encrypt, (CipherParameters)parameters);
            int outputLength = cipher.getOutputSize(input.length);
            byte[] output = new byte[outputLength];
            int outputOffset = cipher.processBytes(input, 0, input.length, output, 0);
            cipher.doFinal(output, outputOffset);
            return output;
        }
        catch (InvalidCipherTextException exception) {
            throw new RuntimeException("Cannot %s data".formatted(encrypt ? "encrypt" : "decrypt"), exception);
        }
    }

    private static byte[] toIv(long iv) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.write(new byte[4]);
            dataOutputStream.writeLong(iv);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
        }
        dataOutputStream.close();
        return byArray;
    }

    public static byte[] decrypt(long iv, byte[] input, byte[] key) {
        return AesGcm.decrypt(iv, input, key, null);
    }

    public static byte[] decrypt(long iv, byte[] input, byte[] key, byte[] additionalData) {
        return AesGcm.cipher(AesGcm.toIv(iv), input, key, additionalData, false);
    }

    public static byte[] encrypt(byte[] iv, byte[] input, byte[] key, byte[] additionalData) {
        return AesGcm.cipher(iv, input, key, additionalData, true);
    }

    public static byte[] encrypt(byte[] iv, byte[] input, byte[] key) {
        return AesGcm.cipher(iv, input, key, null, true);
    }

    public static byte[] decrypt(byte[] iv, byte[] input, byte[] key, byte[] additionalData) {
        return AesGcm.cipher(iv, input, key, additionalData, false);
    }
}

