/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.companion;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.companion.CompanionDevice;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.auth.UserAgentPlatformTypeSpec;

public class CompanionDeviceSpec {
    public static byte[] encode(CompanionDevice protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeString(1, protoInputObject.model());
        outputStream.writeString(2, protoInputObject.manufacturer());
        outputStream.writeInt32(3, UserAgentPlatformTypeSpec.encode(protoInputObject.platform()));
        outputStream.writeString(4, protoInputObject.version());
        return outputStream.toByteArray();
    }

    public static CompanionDevice decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        String model = null;
        String manufacturer = null;
        UserAgent.PlatformType platform = null;
        String version = null;
        block6: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    model = inputStream.readString();
                    continue block6;
                }
                case 2: {
                    manufacturer = inputStream.readString();
                    continue block6;
                }
                case 3: {
                    platform = UserAgentPlatformTypeSpec.decode(inputStream.readInt32()).orElse(null);
                    continue block6;
                }
                case 4: {
                    version = inputStream.readString();
                    continue block6;
                }
            }
            inputStream.skipBytes();
        }
        return new CompanionDevice(model, manufacturer, platform, version);
    }
}

