/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.info;

import com.fasterxml.jackson.core.type.TypeReference;
import it.auties.whatsapp.model.info.Info;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.util.Json;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;

public record MessageIndexInfo(String type, Optional<Jid> chatJid, Optional<String> messageId, boolean fromMe) implements Info
{
    public static MessageIndexInfo of(String type, Jid chatJid, String messageId, boolean fromMe) {
        return new MessageIndexInfo(type, Optional.ofNullable(chatJid), Optional.ofNullable(messageId), fromMe);
    }

    public static MessageIndexInfo ofJson(String json) {
        List<String> array = Json.readValue(json, new TypeReference<List<String>>(){});
        String type = MessageIndexInfo.getProperty(array, 0).orElseThrow(() -> new NoSuchElementException("Cannot parse MessageSync: missing type"));
        Optional<Jid> chatJid = MessageIndexInfo.getProperty(array, 1).map(Jid::of);
        Optional<String> messageId = MessageIndexInfo.getProperty(array, 2);
        Boolean fromMe = MessageIndexInfo.getProperty(array, 3).map(Boolean::parseBoolean).orElse(false);
        return new MessageIndexInfo(type, chatJid, messageId, fromMe);
    }

    private static Optional<String> getProperty(List<String> list, int index) {
        return list.size() > index ? Optional.ofNullable(list.get(index)) : Optional.empty();
    }
}

