/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.mobile;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import it.auties.protobuf.annotation.ProtobufConverter;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.mobile.CountryCode;
import java.util.Optional;

public record PhoneNumber(CountryCode countryCode, long numberWithoutPrefix) {
    public static Optional<PhoneNumber> ofNullable(Long phoneNumber) {
        if (phoneNumber == null) {
            return Optional.empty();
        }
        return Optional.of(PhoneNumber.of(phoneNumber));
    }

    public static PhoneNumber of(String phoneNumber) {
        return PhoneNumber.of(Long.parseLong(phoneNumber));
    }

    @ProtobufConverter
    @JsonCreator
    public static PhoneNumber of(long phoneNumber) {
        try {
            Phonenumber.PhoneNumber parsed = PhoneNumberUtil.getInstance().parse((CharSequence)"+%s".formatted(phoneNumber), null);
            return CountryCode.ofPrefix(String.valueOf(parsed.getCountryCode())).map(countryCode -> new PhoneNumber((CountryCode)((Object)countryCode), parsed.getNationalNumber())).orElseThrow(() -> new IllegalArgumentException("Cannot parse phone number %s".formatted(phoneNumber)));
        }
        catch (Throwable exception) {
            throw new IllegalArgumentException("Cannot parse phone number %s".formatted(phoneNumber), exception);
        }
    }

    @ProtobufConverter
    public long number() {
        return Long.parseLong(this.countryCode.prefix() + this.numberWithoutPrefix);
    }

    public String prefix() {
        return this.countryCode.prefix();
    }

    public Jid toJid() {
        return Jid.of(this.toString());
    }

    @Override
    public String toString() {
        return String.valueOf(this.number());
    }
}

