/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.product;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.message.standard.ImageMessage;
import it.auties.whatsapp.model.message.standard.ImageMessageSpec;
import it.auties.whatsapp.model.product.Product;

public class ProductSpec {
    public static byte[] encode(Product protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream outputStream = new ProtobufOutputStream();
        outputStream.writeBytes(1, ImageMessageSpec.encode(protoInputObject.image()));
        outputStream.writeString(2, protoInputObject.id());
        outputStream.writeString(3, protoInputObject.title());
        outputStream.writeString(4, protoInputObject.description());
        outputStream.writeString(5, protoInputObject.currencyCode());
        outputStream.writeInt64(6, Long.valueOf(protoInputObject.priceAmount1000()));
        outputStream.writeString(7, protoInputObject.retailerId());
        outputStream.writeString(8, protoInputObject.url());
        outputStream.writeUInt32(9, Integer.valueOf(protoInputObject.productImageCount()));
        outputStream.writeString(11, protoInputObject.firstImageId());
        outputStream.writeInt64(12, Long.valueOf(protoInputObject.salePriceAmount1000()));
        return outputStream.toByteArray();
    }

    public static Product decode(byte[] input) {
        if (input == null) {
            return null;
        }
        ProtobufInputStream inputStream = new ProtobufInputStream(input);
        ImageMessage image = null;
        String id = null;
        String title = null;
        String description = null;
        String currencyCode = null;
        long priceAmount1000 = 0L;
        String retailerId = null;
        String url = null;
        int productImageCount = 0;
        String firstImageId = null;
        long salePriceAmount1000 = 0L;
        block13: while (inputStream.readTag()) {
            switch (inputStream.index()) {
                case 1: {
                    image = ImageMessageSpec.decode(inputStream.readBytes());
                    continue block13;
                }
                case 2: {
                    id = inputStream.readString();
                    continue block13;
                }
                case 3: {
                    title = inputStream.readString();
                    continue block13;
                }
                case 4: {
                    description = inputStream.readString();
                    continue block13;
                }
                case 5: {
                    currencyCode = inputStream.readString();
                    continue block13;
                }
                case 6: {
                    priceAmount1000 = inputStream.readInt64();
                    continue block13;
                }
                case 7: {
                    retailerId = inputStream.readString();
                    continue block13;
                }
                case 8: {
                    url = inputStream.readString();
                    continue block13;
                }
                case 9: {
                    productImageCount = inputStream.readInt32();
                    continue block13;
                }
                case 11: {
                    firstImageId = inputStream.readString();
                    continue block13;
                }
                case 12: {
                    salePriceAmount1000 = inputStream.readInt64();
                    continue block13;
                }
            }
            inputStream.skipBytes();
        }
        return new Product(image, id, title, description, currencyCode, priceAmount1000, retailerId, url, productImageCount, firstImageId, salePriceAmount1000);
    }
}

