/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.response;

import com.fasterxml.jackson.core.type.TypeReference;
import it.auties.whatsapp.model.node.Node;
import it.auties.whatsapp.util.Clock;
import it.auties.whatsapp.util.Json;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public record ContactAboutResponse(Optional<String> about, Optional<ZonedDateTime> timestamp) {
    public static ContactAboutResponse ofNode(Node source) {
        return new ContactAboutResponse(source.contentAsString(), Clock.parseSeconds(source.attributes().getLong("t")));
    }

    public static Optional<ContactAboutResponse> ofJson(String json) {
        try {
            Map<String, Object> parsedJson = Json.readValue(json, new TypeReference<Map<String, Object>>(){});
            Map data = (Map)parsedJson.get("data");
            List updates = (List)data.get("xwa2_users_updates_since");
            Map latestUpdate = (Map)updates.getFirst();
            List updatesData = (List)latestUpdate.get("updates");
            Map latestUpdateData = (Map)updatesData.getFirst();
            return Optional.of(new ContactAboutResponse(Optional.ofNullable((String)latestUpdateData.get("text")), Optional.empty()));
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }
}

