/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.keypair;

import it.auties.curve25519.Curve25519;
import it.auties.curve25519.XecUtils;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufMessage;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.model.node.Node;
import it.auties.whatsapp.model.signal.keypair.ISignalKeyPair;
import it.auties.whatsapp.util.KeyHelper;
import java.security.KeyPair;
import java.security.interfaces.XECPrivateKey;
import java.security.interfaces.XECPublicKey;
import java.util.Arrays;

public record SignalKeyPair(@ProtobufProperty(index=1, type=ProtobufType.BYTES) byte[] publicKey, @ProtobufProperty(index=2, type=ProtobufType.BYTES) byte[] privateKey) implements ISignalKeyPair,
ProtobufMessage
{
    public SignalKeyPair(byte[] publicKey, byte[] privateKey) {
        this.publicKey = KeyHelper.withoutHeader(publicKey);
        this.privateKey = privateKey;
    }

    public static SignalKeyPair of(byte[] publicKey) {
        return new SignalKeyPair(publicKey, null);
    }

    public static SignalKeyPair random() {
        KeyPair keyPair = Curve25519.randomKeyPair();
        byte[] publicKey = XecUtils.toBytes((XECPublicKey)((XECPublicKey)keyPair.getPublic()));
        byte[] privateKey = XecUtils.toBytes((XECPrivateKey)((XECPrivateKey)keyPair.getPrivate()));
        return new SignalKeyPair(publicKey, privateKey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof SignalKeyPair)) return false;
        SignalKeyPair that = (SignalKeyPair)other;
        if (!Arrays.equals(this.publicKey(), that.publicKey())) return false;
        if (!Arrays.equals(this.privateKey(), that.privateKey())) return false;
        return true;
    }

    @Override
    public Node toNode() {
        throw new UnsupportedOperationException("Cannot serialize generic signal key pair");
    }

    @Override
    public SignalKeyPair toGenericKeyPair() {
        return this;
    }
}

