/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.keypair;

import it.auties.curve25519.Curve25519;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufMessage;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.model.node.Node;
import it.auties.whatsapp.model.signal.keypair.ISignalKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.util.BytesHelper;
import java.util.NoSuchElementException;
import java.util.Optional;

public record SignalSignedKeyPair(@ProtobufProperty(index=1, type=ProtobufType.INT32) int id, @ProtobufProperty(index=2, type=ProtobufType.OBJECT) SignalKeyPair keyPair, @ProtobufProperty(index=3, type=ProtobufType.BYTES) byte[] signature) implements ISignalKeyPair,
ProtobufMessage
{
    public static SignalSignedKeyPair of(int id, SignalKeyPair identityKeyPair) {
        SignalKeyPair keyPair = SignalKeyPair.random();
        byte[] signature = Curve25519.sign((byte[])identityKeyPair.privateKey(), (byte[])keyPair.encodedPublicKey(), (boolean)true);
        return new SignalSignedKeyPair(id, keyPair, signature);
    }

    public static Optional<SignalSignedKeyPair> of(Node node) {
        if (node == null) {
            return Optional.empty();
        }
        Integer id = node.findNode("id").flatMap(Node::contentAsBytes).map(bytes -> BytesHelper.bytesToInt(bytes, 3)).orElseThrow(() -> new NoSuchElementException("Missing id in SignalSignedKeyPair"));
        byte[] publicKey = (byte[])node.findNode("value").flatMap(Node::contentAsBytes).orElseThrow(() -> new NoSuchElementException("Missing publicKey in SignalSignedKeyPair"));
        SignalKeyPair keyPair = new SignalKeyPair(publicKey, null);
        byte[] signature = node.findNode("signature").flatMap(Node::contentAsBytes).orElse(null);
        return Optional.of(new SignalSignedKeyPair(id, keyPair, signature));
    }

    @Override
    public byte[] privateKey() {
        return this.keyPair.privateKey();
    }

    @Override
    public Node toNode() {
        return Node.of("skey", Node.of("id", this.encodedId()), Node.of("value", this.publicKey()), Node.of("signature", this.signature()));
    }

    @Override
    public SignalKeyPair toGenericKeyPair() {
        return this.keyPair();
    }

    @Override
    public byte[] publicKey() {
        return this.keyPair.publicKey();
    }
}

