/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import it.auties.curve25519.Curve25519;
import it.auties.protobuf.annotation.ProtobufMessageName;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.model.signal.message.SenderKeyMessageSpec;
import it.auties.whatsapp.model.signal.message.SignalProtocolMessage;
import it.auties.whatsapp.util.BytesHelper;
import java.util.Arrays;

@ProtobufMessageName(value="SenderKeyMessage")
public final class SenderKeyMessage
extends SignalProtocolMessage<SenderKeyMessage> {
    @ProtobufProperty(index=1, type=ProtobufType.UINT32)
    private final Integer id;
    @ProtobufProperty(index=2, type=ProtobufType.UINT32)
    private final Integer iteration;
    @ProtobufProperty(index=3, type=ProtobufType.BYTES)
    private final byte[] cipherText;
    private byte[] signingKey;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public SenderKeyMessage(Integer id, Integer iteration, byte[] cipherText, byte[] signingKey) {
        this.id = id;
        this.iteration = iteration;
        this.cipherText = cipherText;
        this.signingKey = signingKey;
    }

    public SenderKeyMessage(int id, int iteration, byte[] cipherText) {
        this.id = id;
        this.iteration = iteration;
        this.cipherText = cipherText;
    }

    public static SenderKeyMessage ofSerialized(byte[] serialized) {
        byte[] data = Arrays.copyOfRange(serialized, 1, serialized.length - 64);
        return (SenderKeyMessage)((SenderKeyMessage)SenderKeyMessageSpec.decode(data).setVersion(BytesHelper.bytesToVersion(serialized[0]))).setSerialized(serialized);
    }

    @Override
    public byte[] serialized() {
        if (this.serialized == null) {
            byte[] serialized = BytesHelper.concat(this.serializedVersion(), SenderKeyMessageSpec.encode(this));
            byte[] signature = Curve25519.sign((byte[])this.signingKey, (byte[])serialized, (boolean)true);
            this.serialized = BytesHelper.concat(serialized, signature);
        }
        return this.serialized;
    }

    public Integer id() {
        return this.id;
    }

    public Integer iteration() {
        return this.iteration;
    }

    public byte[] cipherText() {
        return this.cipherText;
    }

    public byte[] signingKey() {
        return this.signingKey;
    }
}

