/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.sender;

import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufMessage;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.crypto.Hkdf;
import it.auties.whatsapp.util.BytesHelper;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public record SenderMessageKey(@ProtobufProperty(index=1, type=ProtobufType.INT32) int iteration, @ProtobufProperty(index=2, type=ProtobufType.BYTES) byte[] seed, @ProtobufProperty(index=3, type=ProtobufType.BYTES) byte[] iv, @ProtobufProperty(index=4, type=ProtobufType.BYTES) byte[] cipherKey) implements ProtobufMessage
{
    public SenderMessageKey(int iteration, byte[] seed) {
        this(iteration, seed, SenderMessageKey.createIv(seed), SenderMessageKey.createCipherKey(seed));
    }

    private static byte[] createIv(byte[] seed) {
        byte[][] derivative = SenderMessageKey.getDerivedSeed(seed);
        return Arrays.copyOf(derivative[0], 16);
    }

    private static byte[] createCipherKey(byte[] seed) {
        byte[][] derivative = SenderMessageKey.getDerivedSeed(seed);
        byte[] data = Arrays.copyOfRange(derivative[0], 16, derivative[0].length);
        byte[] concat = BytesHelper.concat(data, derivative[1]);
        return Arrays.copyOf(concat, 32);
    }

    private static byte[][] getDerivedSeed(byte[] seed) {
        return Hkdf.deriveSecrets(seed, "WhisperGroup".getBytes(StandardCharsets.UTF_8));
    }
}

