/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import it.auties.whatsapp.model.action.Action;
import it.auties.whatsapp.model.setting.Setting;
import it.auties.whatsapp.model.sync.ActionValueSync;
import it.auties.whatsapp.model.sync.PatchType;
import it.auties.whatsapp.model.sync.RecordSync;
import it.auties.whatsapp.util.Json;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public record PatchRequest(PatchType type, List<PatchEntry> entries) {

    public record PatchEntry(ActionValueSync sync, String index, RecordSync.Operation operation) {
        public static PatchEntry of(ActionValueSync sync, RecordSync.Operation operation, String ... args) {
            String index = Json.writeValueAsString(PatchEntry.createArguments(sync, args));
            return new PatchEntry(sync, index, operation);
        }

        private static List<String> createArguments(ActionValueSync sync, String ... args) {
            Optional<? extends Action> action = sync.action();
            if (action.isPresent()) {
                ArrayList<String> index = new ArrayList<String>();
                index.add(action.get().indexName());
                index.addAll(Arrays.asList(args));
                return index;
            }
            Optional<? extends Setting> setting = sync.setting();
            if (setting.isPresent()) {
                return List.of(setting.get().indexName());
            }
            throw new IllegalArgumentException("Cannot encode %s".formatted(sync));
        }
    }
}

