/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.registration;

import it.auties.curve25519.Curve25519;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.crypto.MD5;
import it.auties.whatsapp.crypto.Sha256;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificate;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificateBuilder;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificateSpec;
import it.auties.whatsapp.model.business.BusinessVerifiedNameDetails;
import it.auties.whatsapp.model.business.BusinessVerifiedNameDetailsBuilder;
import it.auties.whatsapp.model.business.BusinessVerifiedNameDetailsSpec;
import it.auties.whatsapp.model.response.IosVersionResponse;
import it.auties.whatsapp.model.response.WebVersionResponse;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.auth.Version;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Json;
import it.auties.whatsapp.util.Medias;
import it.auties.whatsapp.util.Specification;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Collection;
import java.util.HexFormat;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import net.dongliu.apk.parser.ByteArrayApkFile;
import net.dongliu.apk.parser.bean.ApkSigner;
import net.dongliu.apk.parser.bean.CertificateMeta;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class TokenProvider {
    private static volatile Version webVersion;
    private static volatile Version personalIosVersion;
    private static volatile Version businessIosVersion;
    private static volatile WhatsappApk personalApk;
    private static volatile WhatsappApk businessApk;
    private static Path androidCache;

    public static void setAndroidCache(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            androidCache = path;
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    public static CompletableFuture<Version> getVersion(UserAgent.PlatformType platform) {
        return TokenProvider.getVersion(platform, true);
    }

    private static CompletableFuture<Version> getVersion(UserAgent.PlatformType platform, boolean useCache) {
        return switch (platform) {
            case UserAgent.PlatformType.WEB, UserAgent.PlatformType.WINDOWS, UserAgent.PlatformType.MACOS -> TokenProvider.getWebVersion();
            case UserAgent.PlatformType.ANDROID, UserAgent.PlatformType.ANDROID_BUSINESS -> TokenProvider.getAndroidData(platform.isBusiness(), useCache).thenApply(WhatsappApk::version);
            case UserAgent.PlatformType.IOS -> TokenProvider.getIosVersion(false);
            case UserAgent.PlatformType.IOS_BUSINESS -> TokenProvider.getIosVersion(true);
            case UserAgent.PlatformType.KAIOS -> CompletableFuture.completedFuture(Specification.Whatsapp.DEFAULT_MOBILE_KAIOS_VERSION);
            default -> throw new IllegalStateException("Unsupported mobile os: " + String.valueOf((Object)platform));
        };
    }

    private static CompletableFuture<Version> getIosVersion(boolean business) {
        if (business && businessIosVersion != null) {
            return CompletableFuture.completedFuture(businessIosVersion);
        }
        if (!business && personalIosVersion != null) {
            return CompletableFuture.completedFuture(personalIosVersion);
        }
        HttpClient client = HttpClient.newHttpClient();
        try {
            HttpRequest request = HttpRequest.newBuilder().GET().header("User-Agent", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:120.0) Gecko/20100101 Firefox/120.0").uri(URI.create(business ? "https://itunes.apple.com/lookup?bundleId=net.whatsapp.WhatsAppSMB" : "https://itunes.apple.com/lookup?bundleId=net.whatsapp.WhatsApp")).build();
            CompletionStage completionStage = client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApplyAsync(response -> {
                Version result = Json.readValue((String)response.body(), IosVersionResponse.class).version().orElseThrow();
                if (business) {
                    businessIosVersion = result;
                } else {
                    personalIosVersion = result;
                }
                System.out.println("Result: " + String.valueOf(result));
                return result;
            });
            if (client != null) {
                client.close();
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                throw new RuntimeException("Cannot fetch latest web version", throwable3);
            }
        }
    }

    private static CompletableFuture<Version> getWebVersion() {
        if (webVersion != null) {
            return CompletableFuture.completedFuture(webVersion);
        }
        HttpClient client = HttpClient.newHttpClient();
        try {
            HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create("https://web.whatsapp.com/check-update?version=2.2245.9&platform=web")).build();
            CompletionStage completionStage = client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApplyAsync(response -> {
                WebVersionResponse webVersionResponse = Json.readValue((String)response.body(), WebVersionResponse.class);
                webVersion = Version.of(webVersionResponse.currentVersion());
                return webVersion;
            });
            if (client != null) {
                client.close();
            }
            return completionStage;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                throw new RuntimeException("Cannot fetch latest web version", throwable3);
            }
        }
    }

    public static CompletableFuture<String> getToken(long phoneNumber, UserAgent.PlatformType platform, boolean useJarCache) {
        return switch (platform) {
            case UserAgent.PlatformType.ANDROID, UserAgent.PlatformType.ANDROID_BUSINESS -> TokenProvider.getAndroidToken(String.valueOf(phoneNumber), platform.isBusiness(), useJarCache);
            case UserAgent.PlatformType.IOS, UserAgent.PlatformType.IOS_BUSINESS -> TokenProvider.getIosToken(phoneNumber, platform, useJarCache);
            case UserAgent.PlatformType.KAIOS -> TokenProvider.getKaiOsToken(phoneNumber, platform, useJarCache);
            default -> throw new IllegalStateException("Unsupported mobile os: " + String.valueOf((Object)platform));
        };
    }

    private static CompletableFuture<String> getIosToken(long phoneNumber, UserAgent.PlatformType platform, boolean useJarCache) {
        return TokenProvider.getVersion(platform, useJarCache).thenApply(version -> TokenProvider.getIosToken(phoneNumber, version, platform.isBusiness()));
    }

    private static String getIosToken(long phoneNumber, Version version, boolean business) {
        String staticToken = business ? "USUDuDYDeQhY4RF2fCSp5m3F6kJ1M2J8wS7bbNA2" : "0a1mLfGUIBVrMKF1RdvLI5lkRBvof6vn0fD2QRSM";
        String token = staticToken + HexFormat.of().formatHex(version.toHash()) + phoneNumber;
        return HexFormat.of().formatHex(MD5.calculate(token));
    }

    private static CompletableFuture<String> getKaiOsToken(long phoneNumber, UserAgent.PlatformType platform, boolean useJarCache) {
        return TokenProvider.getVersion(platform, useJarCache).thenApply(version -> TokenProvider.getKaiOsToken(phoneNumber, version));
    }

    private static String getKaiOsToken(long phoneNumber, Version version) {
        byte[] staticTokenPart = HexFormat.of().parseHex("aa8243c465a743c488beb4645dda63edc2ca9a58");
        String pagePart = HexFormat.of().formatHex(Sha256.calculate(BytesHelper.concat(TokenProvider.readKaiOsResource("index.html"), TokenProvider.readKaiOsResource("backendRoot.js"))));
        byte[] phonePart = String.valueOf(phoneNumber).getBytes(StandardCharsets.UTF_8);
        return HexFormat.of().formatHex(Sha256.calculate(BytesHelper.concat(staticTokenPart, pagePart.getBytes(StandardCharsets.UTF_8), phonePart)));
    }

    private static byte[] readKaiOsResource(String name) {
        byte[] byArray;
        block8: {
            InputStream stream = ClassLoader.getSystemResource("token/kaios/" + name).openStream();
            try {
                byArray = stream.readAllBytes();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new UncheckedIOException(exception);
                }
            }
            stream.close();
        }
        return byArray;
    }

    private static CompletableFuture<String> getAndroidToken(String phoneNumber, boolean business, boolean useJarCache) {
        return TokenProvider.getAndroidData(business, useJarCache).thenApplyAsync(whatsappData -> TokenProvider.getAndroidToken(phoneNumber, whatsappData));
    }

    private static String getAndroidToken(String phoneNumber, WhatsappApk whatsappData) {
        try {
            Mac mac = Mac.getInstance("HMACSHA1");
            byte[] secretKeyBytes = whatsappData.secretKey();
            SecretKeySpec secretKey = new SecretKeySpec(secretKeyBytes, 0, secretKeyBytes.length, "PBKDF2");
            mac.init(secretKey);
            whatsappData.certificates().forEach(mac::update);
            mac.update(whatsappData.md5Hash());
            mac.update(phoneNumber.getBytes(StandardCharsets.UTF_8));
            return URLEncoder.encode(Base64.getEncoder().encodeToString(mac.doFinal()), StandardCharsets.UTF_8);
        }
        catch (GeneralSecurityException throwable) {
            throw new RuntimeException("Cannot compute mobile token", throwable);
        }
    }

    private static CompletableFuture<WhatsappApk> getAndroidData(boolean business, boolean useJarCache) {
        if (!business && personalApk != null) {
            return CompletableFuture.completedFuture(personalApk);
        }
        if (business && businessApk != null) {
            return CompletableFuture.completedFuture(businessApk);
        }
        return TokenProvider.getCachedApk(business, useJarCache).map(CompletableFuture::completedFuture).orElseGet(() -> TokenProvider.downloadWhatsappApk(business));
    }

    public static CompletableFuture<WhatsappApk> downloadWhatsappApk(boolean business) {
        return Medias.downloadAsync(business ? Specification.Whatsapp.MOBILE_BUSINESS_ANDROID_URL : Specification.Whatsapp.MOBILE_ANDROID_URL).thenApplyAsync(result -> TokenProvider.getAndroidData(result, business));
    }

    private static Optional<WhatsappApk> getCachedApk(boolean business, boolean useJarCache) {
        try {
            Path localCache = TokenProvider.getAndroidLocalCache(business);
            if (Files.notExists(localCache, new LinkOption[0])) {
                if (useJarCache) {
                    Path jarCache = TokenProvider.getAndroidJarCache(business);
                    return Optional.of(Json.readValue(Files.readString(jarCache), WhatsappApk.class));
                }
                return Optional.empty();
            }
            Instant now = Instant.now();
            FileTime fileTime = Files.getLastModifiedTime(localCache, new LinkOption[0]);
            if (fileTime.toInstant().until(now, ChronoUnit.DAYS) > 7L) {
                return Optional.empty();
            }
            return Optional.of(Json.readValue(Files.readString(localCache), WhatsappApk.class));
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    private static Path getAndroidJarCache(boolean business) throws URISyntaxException {
        URL url = business ? ClassLoader.getSystemResource("token/android/whatsapp_business.json") : ClassLoader.getSystemResource("token/android/whatsapp.json");
        return Path.of(url.toURI());
    }

    private static Path getAndroidLocalCache(boolean business) {
        return androidCache.resolve(business ? "whatsapp_business.json" : "whatsapp.json");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static WhatsappApk getAndroidData(byte[] apk, boolean business) {
        try (ByteArrayApkFile apkFile = new ByteArrayApkFile(apk);){
            Version version = Version.of(apkFile.getApkMeta().getVersionName());
            byte[] md5Hash = MD5.calculate(apkFile.getFileData("classes.dex"));
            SecretKey secretKey = TokenProvider.getSecretKey(apkFile.getApkMeta().getPackageName(), TokenProvider.getAboutLogo(apkFile));
            List<byte[]> certificates = TokenProvider.getCertificates(apkFile);
            if (business) {
                WhatsappApk result = new WhatsappApk(version, md5Hash, secretKey.getEncoded(), certificates, true);
                TokenProvider.cacheWhatsappData(result);
                WhatsappApk whatsappApk = businessApk = result;
                return whatsappApk;
            }
            WhatsappApk result = new WhatsappApk(version, md5Hash, secretKey.getEncoded(), certificates, false);
            TokenProvider.cacheWhatsappData(result);
            WhatsappApk whatsappApk = personalApk = result;
            return whatsappApk;
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new RuntimeException("Cannot extract certificates from APK", exception);
        }
    }

    private static void cacheWhatsappData(WhatsappApk apk) {
        CompletableFuture.runAsync(() -> {
            try {
                String json = Json.writeValueAsString(apk, true);
                Path file = TokenProvider.getAndroidLocalCache(apk.business());
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.writeString(file, (CharSequence)json, new OpenOption[0]);
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
        });
    }

    private static byte[] getAboutLogo(ByteArrayApkFile apkFile) throws IOException {
        byte[] resource = apkFile.getFileData("res/drawable-hdpi/about_logo.png");
        if (resource != null) {
            return resource;
        }
        byte[] resourceV4 = apkFile.getFileData("res/drawable-hdpi-v4/about_logo.png");
        if (resourceV4 != null) {
            return resourceV4;
        }
        byte[] xxResourceV4 = apkFile.getFileData("res/drawable-xxhdpi-v4/about_logo.png");
        if (xxResourceV4 != null) {
            return xxResourceV4;
        }
        throw new NoSuchElementException("Missing about_logo.png from apk");
    }

    private static List<byte[]> getCertificates(ByteArrayApkFile apkFile) throws IOException, CertificateException {
        return apkFile.getApkSingers().stream().map(ApkSigner::getCertificateMetas).flatMap(Collection::stream).map(CertificateMeta::getData).toList();
    }

    private static SecretKey getSecretKey(String packageName, byte[] resource) throws IOException, GeneralSecurityException {
        byte[] result = BytesHelper.concat(packageName.getBytes(StandardCharsets.UTF_8), resource);
        char[] whatsappLogoChars = new char[result.length];
        for (int i = 0; i < result.length; ++i) {
            whatsappLogoChars[i] = (char)result[i];
        }
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1And8BIT");
        PBEKeySpec key = new PBEKeySpec(whatsappLogoChars, Specification.Whatsapp.MOBILE_ANDROID_SALT, 128, 512);
        return factory.generateSecret(key);
    }

    public static String generateBusinessCertificate(Keys keys) {
        BusinessVerifiedNameDetails details = new BusinessVerifiedNameDetailsBuilder().name("").issuer("smb:wa").serial(Math.abs(new SecureRandom().nextLong())).build();
        byte[] encodedDetails = BusinessVerifiedNameDetailsSpec.encode(details);
        BusinessVerifiedNameCertificate certificate = new BusinessVerifiedNameCertificateBuilder().encodedDetails(encodedDetails).signature(Curve25519.sign((byte[])keys.identityKeyPair().privateKey(), (byte[])encodedDetails, (boolean)true)).build();
        return Base64.getUrlEncoder().encodeToString(BusinessVerifiedNameCertificateSpec.encode(certificate));
    }

    public static String generateGpiaToken(byte[] deviceIdentifier, int desiredLength) {
        if (deviceIdentifier == null || desiredLength <= 0) {
            throw new IllegalArgumentException();
        }
        int bytesNeeded = (int)Math.ceil((double)(desiredLength * 3) / 4.0);
        byte[] randomBytes = BytesHelper.random(bytesNeeded - deviceIdentifier.length);
        byte[] tokenBytes = new byte[bytesNeeded];
        System.arraycopy(deviceIdentifier, 0, tokenBytes, 0, deviceIdentifier.length);
        System.arraycopy(randomBytes, 0, tokenBytes, deviceIdentifier.length, randomBytes.length);
        String token = Base64.getEncoder().encodeToString(tokenBytes);
        return token.substring(0, desiredLength);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        androidCache = Path.of(System.getProperty("user.home") + "/.cobalt/token/android", new String[0]);
    }

    public record WhatsappApk(Version version, byte[] md5Hash, byte[] secretKey, Collection<byte[]> certificates, boolean business) {
    }
}

