/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.socket;

import it.auties.whatsapp.api.DisconnectReason;

public enum SocketState {
    WAITING,
    CONNECTED,
    DISCONNECTED,
    RECONNECTING,
    LOGGED_OUT,
    RESTORE;


    static SocketState of(DisconnectReason reason) {
        return switch (reason) {
            default -> throw new MatchException(null, null);
            case DisconnectReason.DISCONNECTED -> DISCONNECTED;
            case DisconnectReason.RECONNECTING -> RECONNECTING;
            case DisconnectReason.LOGGED_OUT -> LOGGED_OUT;
            case DisconnectReason.RESTORE -> RESTORE;
        };
    }

    DisconnectReason toReason() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1, 3 -> DisconnectReason.RECONNECTING;
            case 2 -> DisconnectReason.DISCONNECTED;
            case 4 -> DisconnectReason.LOGGED_OUT;
            case 5 -> DisconnectReason.RESTORE;
        };
    }
}

