/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.socket;

import com.fasterxml.jackson.databind.ObjectMapper;
import it.auties.curve25519.Curve25519;
import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.DisconnectReason;
import it.auties.whatsapp.api.ErrorHandler;
import it.auties.whatsapp.api.PairingCodeHandler;
import it.auties.whatsapp.api.QrHandler;
import it.auties.whatsapp.api.SocketEvent;
import it.auties.whatsapp.api.WebVerificationSupport;
import it.auties.whatsapp.crypto.AesGcm;
import it.auties.whatsapp.crypto.Hkdf;
import it.auties.whatsapp.crypto.Hmac;
import it.auties.whatsapp.exception.HmacValidationException;
import it.auties.whatsapp.model.business.BusinessCategory;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificate;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificateBuilder;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificateSpec;
import it.auties.whatsapp.model.business.BusinessVerifiedNameDetails;
import it.auties.whatsapp.model.business.BusinessVerifiedNameDetailsBuilder;
import it.auties.whatsapp.model.business.BusinessVerifiedNameDetailsSpec;
import it.auties.whatsapp.model.call.Call;
import it.auties.whatsapp.model.call.CallStatus;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatEphemeralTimer;
import it.auties.whatsapp.model.chat.GroupRole;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.contact.ContactStatus;
import it.auties.whatsapp.model.info.ChatMessageInfo;
import it.auties.whatsapp.model.info.ChatMessageInfoBuilder;
import it.auties.whatsapp.model.info.MessageStatusInfo;
import it.auties.whatsapp.model.info.NewsletterMessageInfo;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.jid.JidServer;
import it.auties.whatsapp.model.media.MediaConnection;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.message.model.ChatMessageKeyBuilder;
import it.auties.whatsapp.model.message.model.MessageStatus;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.newsletter.Newsletter;
import it.auties.whatsapp.model.newsletter.NewsletterMetadata;
import it.auties.whatsapp.model.newsletter.NewsletterReaction;
import it.auties.whatsapp.model.node.Attributes;
import it.auties.whatsapp.model.node.Node;
import it.auties.whatsapp.model.privacy.PrivacySettingEntry;
import it.auties.whatsapp.model.privacy.PrivacySettingType;
import it.auties.whatsapp.model.privacy.PrivacySettingValue;
import it.auties.whatsapp.model.request.MessageSendRequest;
import it.auties.whatsapp.model.request.SubscribedNewslettersRequest;
import it.auties.whatsapp.model.response.ContactAboutResponse;
import it.auties.whatsapp.model.response.NewsletterLeaveResponse;
import it.auties.whatsapp.model.response.NewsletterMuteResponse;
import it.auties.whatsapp.model.response.NewsletterResponse;
import it.auties.whatsapp.model.response.NewsletterStateResponse;
import it.auties.whatsapp.model.response.SubscribedNewslettersResponse;
import it.auties.whatsapp.model.signal.auth.DeviceIdentitySpec;
import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentity;
import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentityBuilder;
import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentityHMAC;
import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentityHMACSpec;
import it.auties.whatsapp.model.signal.auth.SignedDeviceIdentitySpec;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalPreKeyPair;
import it.auties.whatsapp.model.sync.PatchType;
import it.auties.whatsapp.socket.SocketHandler;
import it.auties.whatsapp.socket.SocketState;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Clock;
import it.auties.whatsapp.util.Json;
import it.auties.whatsapp.util.Specification;
import it.auties.whatsapp.util.Validate;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

class StreamHandler {
    private static final int REQUIRED_PRE_KEYS_SIZE = 5;
    private static final int PRE_KEYS_UPLOAD_CHUNK = 30;
    private static final int PING_INTERVAL = 30;
    private static final int MEDIA_CONNECTION_DEFAULT_INTERVAL = 60;
    private static final int MAX_ATTEMPTS = 5;
    private static final int DEFAULT_NEWSLETTER_MESSAGES = 100;
    private final SocketHandler socketHandler;
    private final WebVerificationSupport webVerificationSupport;
    private final Map<String, Integer> retries;
    private final AtomicReference<String> lastLinkCodeKey;
    private ScheduledExecutorService service;
    private CompletableFuture<Void> mediaConnectionFuture;

    protected StreamHandler(SocketHandler socketHandler, WebVerificationSupport webVerificationSupport) {
        this.socketHandler = socketHandler;
        this.webVerificationSupport = webVerificationSupport;
        this.retries = new ConcurrentHashMap<String, Integer>();
        this.lastLinkCodeKey = new AtomicReference();
    }

    protected void digest(Node node) {
        switch (node.description()) {
            case "ack": {
                this.digestAck(node);
                break;
            }
            case "call": {
                this.digestCall(node);
                break;
            }
            case "failure": {
                this.digestFailure(node);
                break;
            }
            case "ib": {
                this.digestIb(node);
                break;
            }
            case "iq": {
                this.digestIq(node);
                break;
            }
            case "receipt": {
                this.digestReceipt(node);
                break;
            }
            case "stream:error": {
                this.digestError(node);
                break;
            }
            case "success": {
                this.digestSuccess(node);
                break;
            }
            case "message": {
                this.socketHandler.decodeMessage(node, null, true);
                break;
            }
            case "notification": {
                this.digestNotification(node);
                break;
            }
            case "presence": 
            case "chatstate": {
                this.digestChatState(node);
            }
        }
    }

    private void digestFailure(Node node) {
        int reason = node.attributes().getInt("reason");
        if (reason == 401 || reason == 403 || reason == 405) {
            this.socketHandler.disconnect(DisconnectReason.LOGGED_OUT);
            return;
        }
        this.socketHandler.disconnect(DisconnectReason.RECONNECTING);
    }

    private void digestChatState(Node node) {
        CompletableFuture.runAsync(() -> {
            Jid chatJid = node.attributes().getRequiredJid("from");
            Jid participantJid = node.attributes().getOptionalJid("participant").orElse(chatJid);
            this.updateContactPresence(chatJid, this.getUpdateType(node), participantJid);
        }).exceptionallyAsync(throwable -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.STREAM, (Throwable)throwable));
    }

    private ContactStatus getUpdateType(Node node) {
        Optional<Node> metadata = node.findNode();
        boolean recording = metadata.map(entry -> entry.attributes().getString("media")).filter(entry -> entry.equals("audio")).isPresent();
        if (recording) {
            return ContactStatus.RECORDING;
        }
        return node.attributes().getOptionalString("type").or(() -> metadata.map(Node::description)).flatMap(ContactStatus::of).orElse(ContactStatus.AVAILABLE);
    }

    private void updateContactPresence(Jid chatJid, ContactStatus status, Jid contact) {
        this.socketHandler.store().findChatByJid(chatJid).ifPresent(chat -> this.socketHandler.onUpdateChatPresence(status, contact, (Chat)chat));
    }

    private void digestReceipt(Node node) {
        Jid senderJid = node.attributes().getRequiredJid("from");
        block4: for (String messageId : this.getReceiptsMessageIds(node)) {
            MessageStatusInfo<?> messageStatusInfo;
            Optional<MessageStatusInfo<?>> message = this.socketHandler.store().findMessageById(senderJid, messageId);
            if (message.isEmpty()) continue;
            Objects.requireNonNull(message.get());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ChatMessageInfo.class, NewsletterMessageInfo.class}, messageStatusInfo, n)) {
                case 0: {
                    ChatMessageInfo chatMessageInfo = (ChatMessageInfo)messageStatusInfo;
                    this.onChatReceipt(node, senderJid, chatMessageInfo);
                    continue block4;
                }
                case 1: {
                    NewsletterMessageInfo newsletterMessageInfo = (NewsletterMessageInfo)messageStatusInfo;
                    this.onNewsletterReceipt(node, newsletterMessageInfo);
                    continue block4;
                }
            }
            throw new IllegalStateException("Unexpected value: " + String.valueOf(message.get()));
        }
        this.socketHandler.sendMessageAck(senderJid, node);
    }

    private void onNewsletterReceipt(Node node, NewsletterMessageInfo message) {
        Optional messageStatus = node.attributes().getOptionalString("type").flatMap(MessageStatus::of);
        if (messageStatus.isEmpty()) {
            return;
        }
        message.setStatus((MessageStatus)((Object)messageStatus.get()));
        this.socketHandler.onMessageStatus(message);
    }

    private void onChatReceipt(Node node, Jid chatJid, ChatMessageInfo message) {
        Optional<String> type = node.attributes().getOptionalString("type");
        MessageStatus status = type.flatMap(MessageStatus::of).orElse(MessageStatus.DELIVERED);
        this.socketHandler.store().findChatByJid(chatJid).ifPresent(chat -> {
            int newCount = chat.unreadMessagesCount() - 1;
            chat.setUnreadMessagesCount(newCount);
            Contact participant = node.attributes().getOptionalJid("participant").flatMap(this.socketHandler.store()::findContactByJid).orElse(null);
            this.updateReceipt(status, (Chat)chat, participant, message);
            this.socketHandler.onMessageStatus(message);
        });
        message.setStatus(status);
        if (Objects.equals(type.orElse(null), "retry")) {
            this.sendMessageRetry(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessageRetry(ChatMessageInfo message) {
        if (!message.fromMe()) {
            return;
        }
        Integer attempts = this.retries.getOrDefault(message.id(), 0);
        if (attempts > 5) {
            return;
        }
        try {
            boolean all = message.senderJid().device() == 0;
            this.socketHandler.querySessionsForcefully(message.senderJid());
            message.chat().ifPresent(Chat::clearParticipantsPreKeys);
            List<Jid> recipients = all ? null : List.of(message.senderJid());
            MessageSendRequest.Chat request = new MessageSendRequest.Chat(message, recipients, !all, false, null);
            this.socketHandler.sendMessage(request);
        }
        finally {
            this.retries.put(message.id(), attempts + 1);
        }
    }

    private void updateReceipt(MessageStatus status, Chat chat, Contact participant, ChatMessageInfo message) {
        Set<Jid> container = status == MessageStatus.READ ? message.receipt().readJids() : message.receipt().deliveredJids();
        container.add(participant != null ? participant.jid() : message.senderJid());
        if (chat != null && participant != null && chat.participants().size() != container.size()) {
            return;
        }
        switch (status) {
            case READ: {
                message.receipt().readTimestampSeconds(Clock.nowSeconds());
                break;
            }
            case PLAYED: {
                message.receipt().playedTimestampSeconds(Clock.nowSeconds());
            }
        }
    }

    private List<String> getReceiptsMessageIds(Node node) {
        List<String> messageIds = Stream.ofNullable(node.findNode("list")).flatMap(Optional::stream).map(list -> list.findNodes("item")).flatMap(Collection::stream).map(item -> item.attributes().getOptionalString("id")).flatMap(Optional::stream).collect(Collectors.toList());
        messageIds.add(node.attributes().getRequiredString("id"));
        return messageIds;
    }

    private CallStatus getCallStatus(Node node) {
        return switch (node.description()) {
            case "terminate" -> {
                if (node.attributes().hasValue("reason", "timeout")) {
                    yield CallStatus.TIMED_OUT;
                }
                yield CallStatus.REJECTED;
            }
            case "reject" -> CallStatus.REJECTED;
            case "accept" -> CallStatus.ACCEPTED;
            default -> CallStatus.RINGING;
        };
    }

    private void digestCall(Node node) {
        Jid from = node.attributes().getRequiredJid("from");
        this.socketHandler.sendMessageAck(from, node);
        Node callNode = node.children().peekFirst();
        if (callNode == null) {
            return;
        }
        String callId = callNode.attributes().getString("call-id");
        Jid caller = callNode.attributes().getOptionalJid("call-creator").orElse(from);
        CallStatus status = this.getCallStatus(callNode);
        long timestampSeconds = callNode.attributes().getOptionalLong("t").orElseGet(Clock::nowSeconds);
        boolean isOffline = callNode.attributes().hasKey("offline");
        boolean hasVideo = callNode.hasNode("video");
        Call call = new Call(from, caller, callId, timestampSeconds, hasVideo, status, isOffline);
        this.socketHandler.store().addCall(call);
        this.socketHandler.onCall(call);
    }

    private void digestAck(Node node) {
        String ackClass;
        switch (ackClass = node.attributes().getString("class")) {
            case "call": {
                this.digestCallAck(node);
                break;
            }
            case "message": {
                this.digestMessageAck(node);
            }
        }
    }

    private void digestMessageAck(Node node) {
        int error = node.attributes().getInt("error");
        String messageId = node.id();
        Jid from = node.attributes().getRequiredJid("from");
        MessageStatusInfo match = this.socketHandler.store().findMessageById(from, messageId).orElse(null);
        if (match == null) {
            return;
        }
        if (error != 0) {
            match.setStatus(MessageStatus.ERROR);
            return;
        }
        if (match.status().index() >= MessageStatus.SERVER_ACK.index()) {
            return;
        }
        match.setStatus(MessageStatus.SERVER_ACK);
    }

    private void digestCallAck(Node node) {
        Node relayNode = node.findNode("relay").orElse(null);
        if (relayNode == null) {
            return;
        }
        Jid callCreator = relayNode.attributes().getRequiredJid("call-creator");
        String callId = relayNode.attributes().getString("call-id");
        relayNode.findNodes("participant").stream().map(entry -> entry.attributes().getOptionalJid("jid")).flatMap(Optional::stream).forEach(to -> this.sendRelay(callCreator, callId, (Jid)to));
    }

    private void sendRelay(Jid callCreator, String callId, Jid to) {
        for (byte[] value : Specification.Whatsapp.CALL_RELAY) {
            Node te = Node.of("te", Map.of("latency", 0x2000008), (Object)value);
            Node relay = Node.of("relaylatency", Map.of("call-creator", callCreator, "call-id", callId), (Object)te);
            this.socketHandler.send(Node.of("call", Map.of("to", to), (Object)relay));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void digestNotification(Node node) {
        Jid from = node.attributes().getRequiredJid("from");
        try {
            String type;
            switch (type = node.attributes().getString("type", null)) {
                case "w:gp2": {
                    this.handleGroupNotification(node);
                    return;
                }
                case "server_sync": {
                    this.handleServerSyncNotification(node);
                    return;
                }
                case "account_sync": {
                    this.handleAccountSyncNotification(node);
                    return;
                }
                case "encrypt": {
                    this.handleEncryptNotification(node);
                    return;
                }
                case "picture": {
                    this.handlePictureNotification(node);
                    return;
                }
                case "registration": {
                    this.handleRegistrationNotification(node);
                    return;
                }
                case "link_code_companion_reg": {
                    this.handleCompanionRegistration(node);
                    return;
                }
                case "newsletter": {
                    this.handleNewsletter(from, node);
                    return;
                }
                case "mex": {
                    this.handleMexNamespace(node);
                    return;
                }
            }
            return;
        }
        finally {
            this.socketHandler.sendMessageAck(from, node);
        }
    }

    private void handleNewsletter(Jid newsletterJid, Node node) {
        Optional<Newsletter> newsletter = this.socketHandler.store().findNewsletterByJid(newsletterJid);
        if (newsletter.isEmpty()) {
            return;
        }
        Optional<Node> liveUpdates = node.findNode("live_updates");
        if (liveUpdates.isEmpty()) {
            return;
        }
        Optional<Node> messages = liveUpdates.get().findNode("messages");
        if (messages.isEmpty()) {
            return;
        }
        for (Node messageNode : messages.get().findNodes("message")) {
            String messageId = messageNode.attributes().getRequiredString("server_id");
            Optional<NewsletterMessageInfo> newsletterMessage = this.socketHandler.store().findMessageById(newsletter.get(), messageId);
            if (newsletterMessage.isEmpty()) continue;
            messageNode.findNode("reactions").map(reactions -> reactions.findNodes("reaction")).stream().flatMap(Collection::stream).forEach(reaction -> this.onNewsletterReaction((Node)reaction, (NewsletterMessageInfo)newsletterMessage.get()));
        }
    }

    private void onNewsletterReaction(Node reaction, NewsletterMessageInfo newsletterMessage) {
        String reactionCode = reaction.attributes().getRequiredString("code");
        int reactionCount = reaction.attributes().getRequiredInt("count");
        NewsletterReaction newReaction = new NewsletterReaction(reactionCode, reactionCount, false);
        newsletterMessage.addReaction(newReaction).ifPresent(oldReaction -> newReaction.setFromMe(oldReaction.fromMe()));
    }

    private void handleMexNamespace(Node node) {
        Node update = node.findNode("update").orElse(null);
        if (update == null) {
            return;
        }
        switch (update.attributes().getString("op_name")) {
            case "NotificationNewsletterJoin": {
                this.handleNewsletterJoin(update);
                break;
            }
            case "NotificationNewsletterMuteChange": {
                this.handleNewsletterMute(update);
                break;
            }
            case "NotificationNewsletterLeave": {
                this.handleNewsletterLeave(update);
                break;
            }
            case "NotificationNewsletterUpdate": {
                this.handleNewsletterMetadataUpdate(update);
                break;
            }
            case "NotificationNewsletterStateChange": {
                this.handleNewsletterStateUpdate(update);
                break;
            }
        }
    }

    private void handleNewsletterStateUpdate(Node update) {
        String updatePayload = update.contentAsString().orElseThrow(() -> new NoSuchElementException("Missing state update payload"));
        NewsletterStateResponse updateJson = NewsletterStateResponse.ofJson(updatePayload).orElseThrow(() -> new NoSuchElementException("Malformed state update payload"));
        Newsletter newsletter = this.socketHandler.store().findNewsletterByJid(updateJson.jid()).orElseThrow(() -> new NoSuchElementException("Missing newsletter"));
        newsletter.setState(updateJson.state());
    }

    private void handleNewsletterMetadataUpdate(Node update) {
        String updatePayload = update.contentAsString().orElseThrow(() -> new NoSuchElementException("Missing update payload"));
        NewsletterResponse updateJson = NewsletterResponse.ofJson(updatePayload).orElseThrow(() -> new NoSuchElementException("Malformed update payload"));
        Newsletter newsletter = this.socketHandler.store().findNewsletterByJid(updateJson.newsletter().jid()).orElseThrow(() -> new NoSuchElementException("Missing newsletter"));
        NewsletterMetadata oldMetadata = newsletter.metadata();
        NewsletterMetadata updatedMetadata = updateJson.newsletter().metadata();
        NewsletterMetadata mergedMetadata = new NewsletterMetadata(updatedMetadata.name().or(oldMetadata::name), updatedMetadata.description().or(oldMetadata::description), updatedMetadata.picture().or(oldMetadata::picture), updatedMetadata.handle().or(oldMetadata::handle), updatedMetadata.settings().or(oldMetadata::settings), updatedMetadata.invite().or(oldMetadata::invite), updatedMetadata.verification().or(oldMetadata::verification), updatedMetadata.creationTimestampSeconds().isPresent() ? updatedMetadata.creationTimestampSeconds() : oldMetadata.creationTimestampSeconds());
        newsletter.setMetadata(mergedMetadata);
    }

    private void handleNewsletterJoin(Node update) {
        String joinPayload = update.contentAsString().orElseThrow(() -> new NoSuchElementException("Missing join payload"));
        NewsletterResponse joinJson = NewsletterResponse.ofJson(joinPayload).orElseThrow(() -> new NoSuchElementException("Malformed join payload"));
        this.socketHandler.store().addNewsletter(joinJson.newsletter());
        if (!this.socketHandler.store().historyLength().isZero()) {
            this.socketHandler.queryNewsletterMessages(joinJson.newsletter().jid(), 100);
        }
    }

    private void handleNewsletterMute(Node update) {
        String mutePayload = update.contentAsString().orElseThrow(() -> new NoSuchElementException("Missing mute payload"));
        NewsletterMuteResponse muteJson = NewsletterMuteResponse.ofJson(mutePayload).orElseThrow(() -> new NoSuchElementException("Malformed mute payload"));
        Newsletter newsletter = this.socketHandler.store().findNewsletterByJid(muteJson.jid()).orElseThrow(() -> new NoSuchElementException("Missing newsletter"));
        newsletter.viewerMetadata().ifPresent(viewerMetadata -> viewerMetadata.setMute(muteJson.mute()));
    }

    private void handleNewsletterLeave(Node update) {
        String leavePayload = update.contentAsString().orElseThrow(() -> new NoSuchElementException("Missing leave payload"));
        NewsletterLeaveResponse leaveJson = NewsletterLeaveResponse.ofJson(leavePayload).orElseThrow(() -> new NoSuchElementException("Malformed leave payload"));
        this.socketHandler.store().removeNewsletter(leaveJson.jid());
    }

    private void handleCompanionRegistration(Node node) {
        Jid phoneNumber = this.getPhoneNumberAsJid();
        Node linkCodeCompanionReg = node.findNode("link_code_companion_reg").orElseThrow(() -> new NoSuchElementException("Missing link_code_companion_reg: " + String.valueOf(node)));
        byte[] ref = (byte[])linkCodeCompanionReg.findNode("link_code_pairing_ref").flatMap(Node::contentAsBytes).orElseThrow(() -> new IllegalArgumentException("Missing link_code_pairing_ref: " + String.valueOf(node)));
        byte[] primaryIdentityPublicKey = (byte[])linkCodeCompanionReg.findNode("primary_identity_pub").flatMap(Node::contentAsBytes).orElseThrow(() -> new IllegalArgumentException("Missing primary_identity_pub: " + String.valueOf(node)));
        byte[] primaryEphemeralPublicKeyWrapped = (byte[])linkCodeCompanionReg.findNode("link_code_pairing_wrapped_primary_ephemeral_pub").flatMap(Node::contentAsBytes).orElseThrow(() -> new IllegalArgumentException("Missing link_code_pairing_wrapped_primary_ephemeral_pub: " + String.valueOf(node)));
        byte[] codePairingPublicKey = this.decipherLinkPublicKey(primaryEphemeralPublicKeyWrapped);
        byte[] companionSharedKey = Curve25519.sharedKey((byte[])codePairingPublicKey, (byte[])this.socketHandler.keys().companionKeyPair().privateKey());
        byte[] random = BytesHelper.random(32);
        byte[] linkCodeSalt = BytesHelper.random(32);
        byte[] linkCodePairingExpanded = Hkdf.extractAndExpand(companionSharedKey, linkCodeSalt, "link_code_pairing_key_bundle_encryption_key".getBytes(StandardCharsets.UTF_8), 32);
        byte[] encryptPayload = BytesHelper.concat(this.socketHandler.keys().identityKeyPair().publicKey(), primaryIdentityPublicKey, random);
        byte[] encryptIv = BytesHelper.random(12);
        byte[] encrypted = AesGcm.encrypt(encryptIv, encryptPayload, linkCodePairingExpanded);
        byte[] encryptedPayload = BytesHelper.concat(linkCodeSalt, encryptIv, encrypted);
        byte[] identitySharedKey = Curve25519.sharedKey((byte[])primaryIdentityPublicKey, (byte[])this.socketHandler.keys().identityKeyPair().privateKey());
        byte[] identityPayload = BytesHelper.concat(companionSharedKey, identitySharedKey, random);
        byte[] advSecretPublicKey = Hkdf.extractAndExpand(identityPayload, "adv_secret".getBytes(StandardCharsets.UTF_8), 32);
        this.socketHandler.keys().setCompanionKeyPair(new SignalKeyPair(advSecretPublicKey, this.socketHandler.keys().companionKeyPair().privateKey()));
        Node confirmation = Node.of("link_code_companion_reg", Map.of("jid", phoneNumber, "stage", "companion_finish"), Node.of("link_code_pairing_wrapped_key_bundle", encryptedPayload), Node.of("companion_identity_public", this.socketHandler.keys().identityKeyPair().publicKey()), Node.of("link_code_pairing_ref", ref));
        this.socketHandler.sendQuery("set", "md", confirmation);
    }

    private byte[] decipherLinkPublicKey(byte[] primaryEphemeralPublicKeyWrapped) {
        try {
            byte[] salt = Arrays.copyOfRange(primaryEphemeralPublicKeyWrapped, 0, 32);
            SecretKey secretKey = this.getSecretPairingKey(this.lastLinkCodeKey.get(), salt);
            byte[] iv = Arrays.copyOfRange(primaryEphemeralPublicKeyWrapped, 32, 48);
            byte[] payload = Arrays.copyOfRange(primaryEphemeralPublicKeyWrapped, 48, 80);
            Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
            cipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
            return cipher.doFinal(payload);
        }
        catch (GeneralSecurityException exception) {
            throw new RuntimeException("Cannot decipher link code pairing key", exception);
        }
    }

    private void handleRegistrationNotification(Node node) {
        Optional<Node> child = node.findNode("wa_old_registration");
        if (child.isEmpty()) {
            return;
        }
        OptionalLong code = child.get().attributes().getOptionalLong("code");
        if (code.isEmpty()) {
            return;
        }
        this.socketHandler.onRegistrationCode(code.getAsLong());
    }

    private void handlePictureNotification(Node node) {
        Jid fromJid = node.attributes().getRequiredJid("from");
        Chat fromChat = this.socketHandler.store().findChatByJid(fromJid).orElseGet(() -> this.socketHandler.store().addNewChat(fromJid));
        long timestamp = node.attributes().getLong("t");
        if (fromChat.isGroup()) {
            this.addMessageForGroupStubType(fromChat, ChatMessageInfo.StubType.GROUP_CHANGE_ICON, timestamp, node);
            this.socketHandler.onGroupPictureChanged(fromChat);
            return;
        }
        Contact fromContact = this.socketHandler.store().findContactByJid(fromJid).orElseGet(() -> {
            Contact contact = this.socketHandler.store().addContact(fromJid);
            this.socketHandler.onNewContact(contact);
            return contact;
        });
        this.socketHandler.onContactPictureChanged(fromContact);
    }

    private void handleGroupNotification(Node node) {
        Optional<Node> child = node.findNode();
        if (child.isEmpty()) {
            return;
        }
        Optional<ChatMessageInfo.StubType> stubType = ChatMessageInfo.StubType.of(child.get().description());
        if (stubType.isEmpty()) {
            return;
        }
        this.handleGroupStubNotification(node, stubType.get());
    }

    private void handleGroupStubNotification(Node node, ChatMessageInfo.StubType stubType) {
        long timestamp = node.attributes().getLong("t");
        Jid fromJid = node.attributes().getRequiredJid("from");
        Chat fromChat = this.socketHandler.store().findChatByJid(fromJid).orElseGet(() -> this.socketHandler.store().addNewChat(fromJid));
        this.addMessageForGroupStubType(fromChat, stubType, timestamp, node);
    }

    private void addMessageForGroupStubType(Chat chat, ChatMessageInfo.StubType stubType, long timestamp, Node metadata) {
        Jid participantJid = metadata.attributes().getOptionalJid("participant").orElse(null);
        List<String> parameters = this.getStubTypeParameters(metadata);
        ChatMessageKey key = new ChatMessageKeyBuilder().id(ChatMessageKey.randomId()).chatJid(chat.jid()).senderJid(participantJid).build();
        ChatMessageInfo message = new ChatMessageInfoBuilder().status(MessageStatus.PENDING).timestampSeconds(timestamp).key(key).ignore(true).stubType(stubType).stubParameters(parameters).senderJid(participantJid).build();
        chat.addNewMessage(message);
        this.socketHandler.onNewMessage(message);
        if (participantJid == null) {
            return;
        }
        this.handleGroupStubType(chat, stubType, participantJid);
    }

    private void handleGroupStubType(Chat chat, ChatMessageInfo.StubType stubType, Jid participantJid) {
        switch (stubType) {
            case GROUP_PARTICIPANT_ADD: {
                chat.addParticipant(participantJid, GroupRole.USER);
                break;
            }
            case GROUP_PARTICIPANT_REMOVE: 
            case GROUP_PARTICIPANT_LEAVE: {
                chat.removeParticipant(participantJid);
                break;
            }
            case GROUP_PARTICIPANT_PROMOTE: {
                chat.findParticipant(participantJid).ifPresent(participant -> participant.setRole(GroupRole.ADMIN));
                break;
            }
            case GROUP_PARTICIPANT_DEMOTE: {
                chat.findParticipant(participantJid).ifPresent(participant -> participant.setRole(GroupRole.USER));
            }
        }
    }

    private List<String> getStubTypeParameters(Node metadata) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.add(mapper.writeValueAsString(metadata.attributes().toMap()));
            for (Node child : metadata.children()) {
                Attributes data = child.attributes();
                if (data.isEmpty()) continue;
                attributes.add(mapper.writeValueAsString(data.toMap()));
            }
            return Collections.unmodifiableList(attributes);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot encode stub parameters", exception);
        }
    }

    private void handleEncryptNotification(Node node) {
        Jid chat = node.attributes().getRequiredJid("from");
        if (!chat.isServerJid(JidServer.WHATSAPP)) {
            return;
        }
        long keysSize = node.findNode("count").orElseThrow(() -> new NoSuchElementException("Missing count in notification")).attributes().getLong("value");
        if (keysSize >= 5L) {
            return;
        }
        this.sendPreKeys();
    }

    private void handleAccountSyncNotification(Node node) {
        Optional<Node> child = node.findNode();
        if (child.isEmpty()) {
            return;
        }
        switch (child.get().description()) {
            case "devices": {
                this.handleDevices(child.get());
                break;
            }
            case "privacy": {
                this.changeUserPrivacySetting(child.get());
                break;
            }
            case "disappearing_mode": {
                this.updateUserDisappearingMode(child.get());
                break;
            }
            case "status": {
                this.updateUserAbout(true);
                break;
            }
            case "picture": {
                this.updateUserPicture(true);
                break;
            }
            case "blocklist": {
                this.updateBlocklist(child.orElse(null));
            }
        }
    }

    private void handleDevices(Node child) {
        String deviceHash = child.attributes().getString("dhash");
        this.socketHandler.store().setDeviceHash(deviceHash);
        LinkedHashMap devices = child.findNodes("device").stream().collect(Collectors.toMap(entry -> entry.attributes().getRequiredJid("jid"), entry -> entry.attributes().getInt("key-index"), (first, second) -> second, LinkedHashMap::new));
        Jid companionJid = this.socketHandler.store().jid().orElseThrow(() -> new IllegalStateException("The session isn't connected")).withoutDevice();
        Integer companionDevice = (Integer)devices.remove(companionJid);
        devices.put(companionJid, companionDevice);
        this.socketHandler.store().setLinkedDevicesKeys(devices);
        this.socketHandler.onDevices(devices);
        Node keyIndexListNode = child.findNode("key-index-list").orElseThrow(() -> new NoSuchElementException("Missing index key node from device sync"));
        byte[] signedKeyIndexBytes = keyIndexListNode.contentAsBytes().orElseThrow(() -> new NoSuchElementException("Missing index key from device sync"));
        this.socketHandler.keys().setSignedKeyIndex(signedKeyIndexBytes);
        long signedKeyIndexTimestamp = keyIndexListNode.attributes().getLong("ts");
        this.socketHandler.keys().setSignedKeyIndexTimestamp(signedKeyIndexTimestamp);
    }

    private void updateBlocklist(Node child) {
        child.findNodes("item").forEach(this::updateBlocklistEntry);
    }

    private void updateBlocklistEntry(Node entry) {
        entry.attributes().getOptionalJid("jid").flatMap(this.socketHandler.store()::findContactByJid).ifPresent(contact -> {
            contact.setBlocked(Objects.equals(entry.attributes().getString("action"), "block"));
            this.socketHandler.onContactBlocked((Contact)contact);
        });
    }

    private void changeUserPrivacySetting(Node child) {
        List<Node> category = child.findNodes("category");
        category.forEach(entry -> this.addPrivacySetting((Node)entry, true));
    }

    private void updateUserDisappearingMode(Node child) {
        ChatEphemeralTimer timer = ChatEphemeralTimer.of(child.attributes().getInt("duration"));
        this.socketHandler.store().setNewChatsEphemeralTimer(timer);
    }

    private CompletableFuture<Void> addPrivacySetting(Node node, boolean update) {
        String privacySettingName = node.attributes().getString("name");
        PrivacySettingType privacyType = PrivacySettingType.of(privacySettingName).orElseThrow(() -> new NoSuchElementException("Unknown privacy option: %s".formatted(privacySettingName)));
        String privacyValueName = node.attributes().getString("value");
        PrivacySettingValue privacyValue = PrivacySettingValue.of(privacyValueName).orElseThrow(() -> new NoSuchElementException("Unknown privacy value: %s".formatted(privacyValueName)));
        if (!update) {
            return this.queryPrivacyExcludedContacts(privacyType, privacyValue).thenAcceptAsync(response -> this.socketHandler.store().addPrivacySetting(privacyType, new PrivacySettingEntry(privacyType, privacyValue, (List<Jid>)response)));
        }
        PrivacySettingEntry oldEntry = this.socketHandler.store().findPrivacySetting(privacyType);
        List<Jid> newValues = this.getUpdatedBlockedList(node, oldEntry, privacyValue);
        PrivacySettingEntry newEntry = new PrivacySettingEntry(privacyType, privacyValue, Collections.unmodifiableList(newValues));
        this.socketHandler.store().addPrivacySetting(privacyType, newEntry);
        this.socketHandler.onPrivacySettingChanged(oldEntry, newEntry);
        return CompletableFuture.completedFuture(null);
    }

    private List<Jid> getUpdatedBlockedList(Node node, PrivacySettingEntry privacyEntry, PrivacySettingValue privacyValue) {
        if (privacyValue != PrivacySettingValue.CONTACTS_EXCEPT) {
            return List.of();
        }
        ArrayList<Jid> newValues = new ArrayList<Jid>(privacyEntry.excluded());
        for (Node entry : node.findNodes("user")) {
            Jid jid = entry.attributes().getRequiredJid("jid");
            if (entry.attributes().hasValue("action", "add")) {
                newValues.add(jid);
                continue;
            }
            newValues.remove(jid);
        }
        return newValues;
    }

    private CompletableFuture<List<Jid>> queryPrivacyExcludedContacts(PrivacySettingType type, PrivacySettingValue value) {
        if (value != PrivacySettingValue.CONTACTS_EXCEPT) {
            return CompletableFuture.completedFuture(List.of());
        }
        return this.socketHandler.sendQuery("get", "privacy", Node.of("privacy", (Object)Node.of("list", Map.of("name", type.data(), "value", value.data())))).thenApplyAsync(this::parsePrivacyExcludedContacts);
    }

    private List<Jid> parsePrivacyExcludedContacts(Node result) {
        return result.findNode("privacy").orElseThrow(() -> new NoSuchElementException("Missing privacy in newsletters: %s".formatted(result))).findNode("list").orElseThrow(() -> new NoSuchElementException("Missing list in newsletters: %s".formatted(result))).findNodes("user").stream().map(user -> user.attributes().getOptionalJid("jid")).flatMap(Optional::stream).toList();
    }

    private void handleServerSyncNotification(Node node) {
        if (!this.socketHandler.keys().initialAppSync()) {
            return;
        }
        PatchType[] patches = (PatchType[])node.findNodes("collection").stream().map(entry -> entry.attributes().getRequiredString("name")).map(PatchType::of).toArray(PatchType[]::new);
        this.socketHandler.pullPatch(patches);
    }

    private void digestIb(Node node) {
        Optional<Node> dirty = node.findNode("dirty");
        if (dirty.isEmpty()) {
            Validate.isTrue(!node.hasNode("downgrade_webclient"), "Multi device beta is not enabled. Please enable it from Whatsapp", new Object[0]);
            return;
        }
        String type = dirty.get().attributes().getString("type");
        if (!Objects.equals(type, "account_sync")) {
            return;
        }
        String timestamp = dirty.get().attributes().getString("timestamp");
        this.socketHandler.sendQuery("set", "urn:xmpp:whatsapp:dirty", Node.of("clean", Map.of("type", type, "timestamp", timestamp)));
    }

    private void digestError(Node node) {
        if (node.hasNode("bad-mac")) {
            this.socketHandler.handleFailure(ErrorHandler.Location.CRYPTOGRAPHY, new RuntimeException("Detected a bad mac"));
            return;
        }
        int statusCode = node.attributes().getInt("code");
        switch (statusCode) {
            case 503: {
                this.socketHandler.disconnect(DisconnectReason.RECONNECTING);
                break;
            }
            case 500: {
                this.socketHandler.disconnect(DisconnectReason.LOGGED_OUT);
                break;
            }
            case 401: {
                this.handleStreamError(node);
                break;
            }
            default: {
                node.children().forEach(error -> this.socketHandler.store().resolvePendingRequest((Node)error, true));
            }
        }
    }

    private void handleStreamError(Node node) {
        Node child = node.children().getFirst();
        String type = child.attributes().getString("type");
        String reason = child.attributes().getString("reason", type);
        if (!Objects.equals(reason, "device_removed")) {
            this.socketHandler.handleFailure(ErrorHandler.Location.STREAM, new RuntimeException(reason));
            return;
        }
        this.socketHandler.disconnect(DisconnectReason.LOGGED_OUT);
    }

    private void digestSuccess(Node node) {
        node.attributes().getOptionalJid("lid").ifPresent(this.socketHandler.store()::setLid);
        this.socketHandler.sendQuery("set", "passive", Node.of("active"));
        if (!this.socketHandler.keys().hasPreKeys()) {
            this.sendPreKeys();
        }
        this.createMediaConnection(0, null);
        CompletionStage loggedInFuture = ((CompletableFuture)this.queryInitialInfo().thenRunAsync(this::onInitialInfo)).exceptionallyAsync(throwable -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.LOGIN, (Throwable)throwable));
        boolean registered = this.socketHandler.keys().registered();
        if (!registered) {
            ((CompletableFuture)CompletableFuture.allOf(this.queryGroups(), this.queryNewsletters()).exceptionally(throwable -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.LOGIN, (Throwable)throwable))).thenRun(this::onRegistration);
            return;
        }
        CompletionStage attributionFuture = this.socketHandler.store().serializer().attributeStore(this.socketHandler.store()).exceptionallyAsync(exception -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.MESSAGE, (Throwable)exception));
        CompletableFuture.allOf(new CompletableFuture[]{loggedInFuture, attributionFuture}).thenRunAsync(this::onAttribution);
    }

    private void onRegistration() {
        this.socketHandler.store().serialize(true);
        this.socketHandler.keys().serialize(true);
    }

    private void onAttribution() {
        this.socketHandler.onChats();
        this.socketHandler.onNewsletters();
    }

    private CompletableFuture<Void> queryNewsletters() {
        SubscribedNewslettersRequest query = new SubscribedNewslettersRequest(new SubscribedNewslettersRequest.Variable());
        return ((CompletableFuture)this.socketHandler.sendQuery("get", "w:mex", Node.of("query", Map.of("query_id", "6388546374527196"), (Object)Json.writeValueAsBytes(query))).thenAcceptAsync(this::parseNewsletters)).exceptionallyAsync(throwable -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.LOGIN, (Throwable)throwable));
    }

    private void parseNewsletters(Node result) {
        String newslettersPayload = (String)result.findNode("result").flatMap(Node::contentAsString).orElseThrow(() -> new NoSuchElementException("Missing newsletter payload"));
        SubscribedNewslettersResponse newslettersJson = SubscribedNewslettersResponse.ofJson(newslettersPayload).orElseThrow(() -> new NoSuchElementException("Malformed newsletters payload: " + newslettersPayload));
        this.onNewsletters(newslettersJson);
    }

    private void onNewsletters(SubscribedNewslettersResponse result) {
        boolean noMessages = this.socketHandler.store().historyLength().isZero();
        List<Newsletter> data = result.newsletters();
        CompletableFuture[] futures = noMessages ? null : new CompletableFuture[data.size()];
        for (int index = 0; index < data.size(); ++index) {
            Newsletter newsletter = data.get(index);
            this.socketHandler.store().addNewsletter(newsletter);
            if (noMessages) continue;
            futures[index] = this.socketHandler.queryNewsletterMessages(newsletter, 100);
        }
        if (noMessages) {
            this.socketHandler.onNewsletters();
            return;
        }
        ((CompletableFuture)CompletableFuture.allOf(futures).thenRun(this.socketHandler::onNewsletters)).exceptionally(throwable -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.MESSAGE, (Throwable)throwable));
    }

    private CompletableFuture<Void> queryGroups() {
        return this.socketHandler.sendQuery(JidServer.GROUP.toJid(), "get", "w:g2", Node.of("participating", Node.of("participants"), Node.of("description"))).thenAcceptAsync(this::onGroupsQuery);
    }

    private void onGroupsQuery(Node result) {
        Optional<Node> groups = result.findNode("groups");
        if (groups.isEmpty()) {
            return;
        }
        groups.get().findNodes("group").forEach(this.socketHandler::handleGroupMetadata);
    }

    private CompletableFuture<Node> setBusinessCertificate() {
        BusinessVerifiedNameDetails details = new BusinessVerifiedNameDetailsBuilder().name("").issuer("smb:wa").serial(Math.abs(ThreadLocalRandom.current().nextLong())).build();
        byte[] encodedDetails = BusinessVerifiedNameDetailsSpec.encode(details);
        BusinessVerifiedNameCertificate certificate = new BusinessVerifiedNameCertificateBuilder().encodedDetails(encodedDetails).signature(Curve25519.sign((byte[])this.socketHandler.keys().identityKeyPair().privateKey(), (byte[])encodedDetails, (boolean)true)).build();
        return this.socketHandler.sendQuery("set", "w:biz", Node.of("verified_name", Map.of("v", 2), (Object)BusinessVerifiedNameCertificateSpec.encode(certificate)));
    }

    private CompletableFuture<Node> setBusinessProfile() {
        String version = this.socketHandler.store().properties().getOrDefault("biz_profile_options", "2");
        ArrayList body = new ArrayList();
        this.socketHandler.store().businessAddress().ifPresent(value -> body.add(Node.of("address", value)));
        this.socketHandler.store().businessLongitude().ifPresent(value -> body.add(Node.of("longitude", value)));
        this.socketHandler.store().businessLatitude().ifPresent(value -> body.add(Node.of("latitude", value)));
        this.socketHandler.store().businessDescription().ifPresent(value -> body.add(Node.of("description", value)));
        this.socketHandler.store().businessWebsite().ifPresent(value -> body.add(Node.of("website", value)));
        this.socketHandler.store().businessEmail().ifPresent(value -> body.add(Node.of("email", value)));
        return this.getBusinessCategoryNode().thenComposeAsync(result -> {
            body.add(Node.of("categories", (Object)Node.of("category", Map.of("id", result.id()))));
            return this.socketHandler.sendQuery("set", "w:biz", Node.of("business_profile", Map.of("v", version), (Object)body));
        });
    }

    private CompletableFuture<Node> getBusinessCategoryNode() {
        return this.socketHandler.store().businessCategory().map(businessCategory -> CompletableFuture.completedFuture(Node.of("category", Map.of("id", businessCategory.id())))).orElseGet(() -> this.socketHandler.queryBusinessCategories().thenApplyAsync(entries -> Node.of("category", Map.of("id", ((BusinessCategory)entries.getFirst()).id()))));
    }

    private void schedulePing() {
        if (this.service != null && !this.service.isShutdown()) {
            return;
        }
        this.service = Executors.newSingleThreadScheduledExecutor();
        this.service.scheduleAtFixedRate(this::sendPing, 0L, 30L, TimeUnit.SECONDS);
    }

    private void onInitialInfo() {
        this.schedulePing();
        this.socketHandler.onLoggedIn();
        if (!this.socketHandler.keys().registered()) {
            this.socketHandler.keys().setRegistered(this.socketHandler.keys().registered() || this.socketHandler.store().clientType() == ClientType.WEB);
            return;
        }
        this.socketHandler.onContacts();
    }

    private CompletableFuture<Void> queryInitialInfo() {
        return this.queryRequiredInfo().thenComposeAsync(ignored -> CompletableFuture.allOf(this.updateSelfPresence(), this.queryInitialBlockList(), this.queryInitialPrivacySettings(), this.updateUserAbout(false), this.updateUserPicture(false)));
    }

    private CompletableFuture<Void> queryRequiredInfo() {
        return switch (this.socketHandler.store().clientType()) {
            default -> throw new MatchException(null, null);
            case ClientType.WEB -> this.queryRequiredWebInfo();
            case ClientType.MOBILE -> this.queryRequiredMobileInfo();
        };
    }

    private CompletableFuture<Void> queryRequiredMobileInfo() {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.socketHandler.sendQuery("get", "w", Node.of("props", Map.of("protocol", "2", "hash", ""))).thenAcceptAsync(this::parseProps)).thenComposeAsync(ignored -> this.checkBusinessStatus())).thenRunAsync(() -> {
            this.socketHandler.sendQuery("get", "urn:xmpp:whatsapp:push", Node.of("config", Map.of("version", 1))).exceptionallyAsync(exception -> (Node)this.socketHandler.handleFailure(ErrorHandler.Location.LOGIN, (Throwable)exception));
            this.socketHandler.sendQuery("set", "urn:xmpp:whatsapp:dirty", Node.of("clean", Map.of("timestamp", 0, "type", "account_sync"))).exceptionallyAsync(exception -> (Node)this.socketHandler.handleFailure(ErrorHandler.Location.LOGIN, (Throwable)exception));
            if (this.socketHandler.store().device().platform().isBusiness()) {
                this.socketHandler.sendQuery("get", "fb:thrift_iq", Map.of("smax_id", 42), Node.of("linked_accounts")).exceptionallyAsync(exception -> (Node)this.socketHandler.handleFailure(ErrorHandler.Location.LOGIN, (Throwable)exception));
            }
        })).exceptionallyAsync(exception -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.LOGIN, (Throwable)exception));
    }

    private CompletableFuture<Void> queryRequiredWebInfo() {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.socketHandler.sendQuery("get", "w", Node.of("props")).thenAcceptAsync(this::parseProps)).thenComposeAsync(ignored -> this.socketHandler.sendQuery("get", "abt", Node.of("props", Map.of("protocol", "1"))))).thenAcceptAsync(result -> {})).exceptionallyAsync(exception -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.LOGIN, (Throwable)exception));
    }

    private CompletableFuture<Void> checkBusinessStatus() {
        if (!this.socketHandler.store().device().platform().isBusiness() || this.socketHandler.keys().businessCertificate()) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.allOf(this.setBusinessCertificate(), this.setBusinessProfile()).thenRunAsync(() -> this.socketHandler.keys().setBusinessCertificate(true));
    }

    private CompletableFuture<Void> queryInitialPrivacySettings() {
        return this.socketHandler.sendQuery("get", "privacy", Node.of("privacy")).thenComposeAsync(this::parsePrivacySettings);
    }

    private CompletableFuture<Void> queryInitialBlockList() {
        return this.socketHandler.queryBlockList().thenAcceptAsync(entry -> entry.forEach(this::markBlocked));
    }

    private CompletableFuture<Void> updateSelfPresence() {
        if (!this.socketHandler.store().automaticPresenceUpdates()) {
            if (!this.socketHandler.store().online()) {
                this.socketHandler.sendWithNoResponse(Node.of("presence", Map.of("name", this.socketHandler.store().name(), "type", "unavailable")));
            }
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)this.socketHandler.sendWithNoResponse(Node.of("presence", Map.of("name", this.socketHandler.store().name(), "type", "available"))).thenRun(this::onPresenceUpdated)).exceptionally(exception -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.STREAM, (Throwable)exception));
    }

    private void onPresenceUpdated() {
        this.socketHandler.store().setOnline(true);
        this.socketHandler.store().jid().flatMap(this.socketHandler.store()::findContactByJid).ifPresent(entry -> entry.setLastKnownPresence(ContactStatus.AVAILABLE).setLastSeen(ZonedDateTime.now()));
    }

    private CompletableFuture<Void> updateUserAbout(boolean update) {
        Optional<Jid> jid = this.socketHandler.store().jid();
        if (jid.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.socketHandler.queryAbout(jid.get().withoutDevice()).thenAcceptAsync(result -> this.parseNewAbout(result.orElse(null), update));
    }

    private void parseNewAbout(ContactAboutResponse result, boolean update) {
        if (result == null) {
            return;
        }
        result.about().ifPresent(about -> {
            this.socketHandler.store().setAbout((String)about);
            if (!update) {
                return;
            }
            Optional<String> oldStatus = this.socketHandler.store().about();
            this.socketHandler.onUserAboutChanged((String)about, oldStatus.orElse(null));
        });
    }

    private CompletableFuture<Void> updateUserPicture(boolean update) {
        Optional<Jid> jid = this.socketHandler.store().jid();
        if (jid.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.socketHandler.queryPicture(jid.get().withoutDevice()).thenAcceptAsync(result -> this.handleUserPictureChange(result.orElse(null), update));
    }

    private void handleUserPictureChange(URI newPicture, boolean update) {
        URI oldStatus = this.socketHandler.store().profilePicture().orElse(null);
        this.socketHandler.store().setProfilePicture(newPicture);
        if (!update) {
            return;
        }
        this.socketHandler.onUserPictureChanged(newPicture, oldStatus);
    }

    private void markBlocked(Jid entry) {
        this.socketHandler.store().findContactByJid(entry).orElseGet(() -> {
            Contact contact = this.socketHandler.store().addContact(entry);
            this.socketHandler.onNewContact(contact);
            return contact;
        }).setBlocked(true);
    }

    private CompletableFuture<Void> parsePrivacySettings(Node result) {
        CompletableFuture[] privacy = (CompletableFuture[])result.findNode("privacy").orElseThrow(() -> new NoSuchElementException("Missing privacy in newsletters: %s".formatted(result))).children().stream().map(entry -> this.addPrivacySetting((Node)entry, false)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(privacy);
    }

    private void parseProps(Node result) {
        ConcurrentHashMap properties = result.findNode("props").stream().map(entry -> entry.findNodes("prop")).flatMap(Collection::stream).map(node -> Map.entry(node.attributes().getString("name"), node.attributes().getString("value"))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (first, second) -> second, ConcurrentHashMap::new));
        this.socketHandler.store().addProperties(properties);
        this.socketHandler.onMetadata(properties);
    }

    private void sendPing() {
        if (this.socketHandler.state() != SocketState.CONNECTED) {
            return;
        }
        ((CompletableFuture)this.socketHandler.sendQuery("get", "w:p", Node.of("ping")).thenRun(() -> this.socketHandler.onSocketEvent(SocketEvent.PING))).exceptionallyAsync(throwable -> (Void)this.socketHandler.handleFailure(ErrorHandler.Location.STREAM, (Throwable)throwable));
        this.socketHandler.store().serialize(true);
        this.socketHandler.store().serializer().linkMetadata(this.socketHandler.store());
        this.socketHandler.keys().serialize(true);
    }

    private void createMediaConnection(int tries, Throwable error) {
        if (this.socketHandler.state() != SocketState.CONNECTED) {
            return;
        }
        if (tries >= 5) {
            this.socketHandler.store().setMediaConnection(null);
            this.socketHandler.handleFailure(ErrorHandler.Location.MEDIA_CONNECTION, error);
            this.scheduleMediaConnection(60);
            return;
        }
        ((CompletableFuture)((CompletableFuture)this.socketHandler.sendQuery("set", "w:m", Node.of("media_conn")).thenApplyAsync(node -> {
            Node mediaConnection = node.findNode("media_conn").orElse((Node)node);
            String auth = mediaConnection.attributes().getString("auth");
            int ttl = mediaConnection.attributes().getInt("ttl");
            int maxBuckets = mediaConnection.attributes().getInt("max_buckets");
            long timestamp = System.currentTimeMillis();
            List<String> hosts = mediaConnection.findNodes("host").stream().map(Node::attributes).map(attributes -> attributes.getString("hostname")).toList();
            return new MediaConnection(auth, ttl, maxBuckets, timestamp, hosts);
        })).thenAcceptAsync(result -> {
            this.socketHandler.store().setMediaConnection((MediaConnection)result);
            this.scheduleMediaConnection(result.ttl());
        })).exceptionallyAsync(throwable -> {
            this.createMediaConnection(tries + 1, (Throwable)throwable);
            return null;
        });
    }

    private void scheduleMediaConnection(int seconds) {
        Executor executor = CompletableFuture.delayedExecutor(seconds, TimeUnit.SECONDS);
        this.mediaConnectionFuture = CompletableFuture.runAsync(() -> this.createMediaConnection(0, null), executor);
    }

    private void digestIq(Node node) {
        Node container = node.findNode().orElse(null);
        if (container == null) {
            return;
        }
        switch (container.description()) {
            case "pair-device": {
                this.startPairing(node, container);
                break;
            }
            case "pair-success": {
                this.confirmPairing(node, container);
            }
        }
    }

    private void sendPreKeys() {
        int startId = this.socketHandler.keys().lastPreKeyId() + 1;
        List<Node> preKeys = IntStream.range(startId, startId + 30).mapToObj(SignalPreKeyPair::random).peek(this.socketHandler.keys()::addPreKey).map(SignalPreKeyPair::toNode).toList();
        this.socketHandler.sendQuery("set", "encrypt", Node.of("registration", this.socketHandler.keys().encodedRegistrationId()), Node.of("type", Specification.Signal.KEY_BUNDLE_TYPE), Node.of("identity", this.socketHandler.keys().identityKeyPair().publicKey()), Node.of("list", preKeys), this.socketHandler.keys().signedKeyPair().toNode());
    }

    private void startPairing(Node node, Node container) {
        WebVerificationSupport webVerificationSupport = this.webVerificationSupport;
        Objects.requireNonNull(webVerificationSupport);
        WebVerificationSupport webVerificationSupport2 = webVerificationSupport;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{QrHandler.class, PairingCodeHandler.class}, (Object)webVerificationSupport2, n)) {
            case 0: {
                QrHandler qrHandler = (QrHandler)webVerificationSupport2;
                this.printQrCode(qrHandler, container);
                this.sendConfirmNode(node, null);
                break;
            }
            case 1: {
                PairingCodeHandler codeHandler = (PairingCodeHandler)webVerificationSupport2;
                this.askPairingCode(codeHandler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot verify account: unknown verification method");
            }
        }
    }

    private void askPairingCode(PairingCodeHandler codeHandler) {
        String code = BytesHelper.bytesToCrockford(BytesHelper.random(5));
        Node registration = Node.of("link_code_companion_reg", Map.of("jid", this.getPhoneNumberAsJid(), "stage", "companion_hello", "should_show_push_notification", true), Node.of("link_code_pairing_wrapped_companion_ephemeral_pub", this.cipherLinkPublicKey(code)), Node.of("companion_server_auth_key_pub", this.socketHandler.keys().noiseKeyPair().publicKey()), Node.of("companion_platform_id", 49), Node.of("companion_platform_display", "Chrome (Linux)".getBytes(StandardCharsets.UTF_8)), Node.of("link_code_pairing_nonce", 0));
        this.socketHandler.sendQuery("set", "md", registration).thenAccept(result -> {
            this.lastLinkCodeKey.set(code);
            codeHandler.accept(code);
        });
    }

    private byte[] cipherLinkPublicKey(String linkCodeKey) {
        try {
            byte[] salt = BytesHelper.random(32);
            byte[] randomIv = BytesHelper.random(16);
            SecretKey secretKey = this.getSecretPairingKey(linkCodeKey, salt);
            Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
            cipher.init(1, (Key)secretKey, new IvParameterSpec(randomIv));
            byte[] ciphered = cipher.doFinal(this.socketHandler.keys().companionKeyPair().publicKey());
            return BytesHelper.concat(salt, randomIv, ciphered);
        }
        catch (GeneralSecurityException exception) {
            throw new RuntimeException("Cannot cipher link code pairing key", exception);
        }
    }

    private Jid getPhoneNumberAsJid() {
        return this.socketHandler.store().phoneNumber().map(PhoneNumber::toJid).orElseThrow(() -> new IllegalArgumentException("Missing phone number while registering via OTP"));
    }

    private SecretKey getSecretPairingKey(String pairingKey, byte[] salt) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec spec = new PBEKeySpec(pairingKey.toCharArray(), salt, 131072, 256);
            SecretKey tmp = factory.generateSecret(spec);
            return new SecretKeySpec(tmp.getEncoded(), "AES");
        }
        catch (GeneralSecurityException exception) {
            throw new RuntimeException("Cannot compute pairing key", exception);
        }
    }

    private void printQrCode(QrHandler qrHandler, Node container) {
        String ref = (String)container.findNode("ref").flatMap(Node::contentAsString).orElseThrow(() -> new NoSuchElementException("Missing ref"));
        String qr = String.join((CharSequence)",", ref, Base64.getEncoder().encodeToString(this.socketHandler.keys().noiseKeyPair().publicKey()), Base64.getEncoder().encodeToString(this.socketHandler.keys().identityKeyPair().publicKey()), Base64.getEncoder().encodeToString(this.socketHandler.keys().companionKeyPair().publicKey()), "1");
        qrHandler.accept(qr);
    }

    private void confirmPairing(Node node, Node container) {
        this.saveCompanion(container);
        Node deviceIdentity = container.findNode("device-identity").orElseThrow(() -> new NoSuchElementException("Missing device identity"));
        SignedDeviceIdentityHMAC advIdentity = SignedDeviceIdentityHMACSpec.decode(deviceIdentity.contentAsBytes().orElseThrow());
        byte[] advSign = Hmac.calculateSha256(advIdentity.details(), this.socketHandler.keys().companionKeyPair().publicKey());
        if (!Arrays.equals(advIdentity.hmac(), advSign)) {
            this.socketHandler.handleFailure(ErrorHandler.Location.LOGIN, new HmacValidationException("adv_sign"));
            return;
        }
        SignedDeviceIdentity account = SignedDeviceIdentitySpec.decode(advIdentity.details());
        byte[] message = BytesHelper.concat(Specification.Whatsapp.ACCOUNT_SIGNATURE_HEADER, account.details(), this.socketHandler.keys().identityKeyPair().publicKey());
        if (!Curve25519.verifySignature((byte[])account.accountSignatureKey(), (byte[])message, (byte[])account.accountSignature())) {
            this.socketHandler.handleFailure(ErrorHandler.Location.LOGIN, new HmacValidationException("message_header"));
            return;
        }
        byte[] deviceSignatureMessage = BytesHelper.concat(Specification.Whatsapp.DEVICE_WEB_SIGNATURE_HEADER, account.details(), this.socketHandler.keys().identityKeyPair().publicKey(), account.accountSignatureKey());
        SignedDeviceIdentity result = new SignedDeviceIdentityBuilder().accountSignature(account.accountSignature()).accountSignatureKey(account.accountSignatureKey()).details(account.details()).deviceSignature(Curve25519.sign((byte[])this.socketHandler.keys().identityKeyPair().privateKey(), (byte[])deviceSignatureMessage, (boolean)true)).build();
        int keyIndex = DeviceIdentitySpec.decode(result.details()).keyIndex();
        byte[] outgoingDeviceIdentity = SignedDeviceIdentitySpec.encode(new SignedDeviceIdentity(result.details(), null, result.accountSignature(), result.deviceSignature()));
        Node devicePairNode = Node.of("pair-device-sign", (Object)Node.of("device-identity", Map.of("key-index", keyIndex), (Object)outgoingDeviceIdentity));
        this.socketHandler.keys().companionIdentity(result);
        this.sendConfirmNode(node, devicePairNode);
    }

    private void sendConfirmNode(Node node, Node content) {
        LinkedHashMap<String, Object> attributes = Attributes.of(new Map.Entry[0]).put("id", node.id()).put("type", "result").put("to", JidServer.WHATSAPP.toJid()).toMap();
        Node request = Node.of("iq", attributes, (Object)content);
        this.socketHandler.sendWithNoResponse(request);
    }

    private void saveCompanion(Node container) {
        Node node = container.findNode("device").orElseThrow(() -> new NoSuchElementException("Missing device"));
        Jid companion = node.attributes().getOptionalJid("jid").orElseThrow(() -> new NoSuchElementException("Missing companion"));
        this.socketHandler.store().setJid(companion);
        this.socketHandler.store().setPhoneNumber(PhoneNumber.of(companion.user()));
        this.socketHandler.markConnected();
        Contact me = new Contact(companion.withoutDevice(), this.socketHandler.store().name(), null, null, ContactStatus.AVAILABLE, Clock.nowSeconds(), false);
        this.socketHandler.store().addContact(me);
    }

    protected void dispose() {
        if (this.mediaConnectionFuture != null) {
            this.mediaConnectionFuture.cancel(true);
        }
        this.retries.clear();
        if (this.service != null) {
            this.service.shutdownNow();
        }
        this.lastLinkCodeKey.set(null);
    }
}

