/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import it.auties.protobuf.annotation.ProtobufConverter;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class FutureReference<T> {
    private T value;
    private CompletableFuture<T> future;

    @JsonCreator
    public FutureReference(T initialValue) {
        this.value = Objects.requireNonNull(initialValue, "Missing value");
    }

    @ProtobufConverter
    public static <T> FutureReference<T> of(T initialValue) {
        return new FutureReference<T>(initialValue);
    }

    public FutureReference(T initialValue, Supplier<CompletableFuture<T>> defaultValue) {
        this.value = initialValue;
        if (initialValue == null) {
            this.future = defaultValue.get();
        }
    }

    @ProtobufConverter
    @JsonValue
    public T value() {
        if (this.future != null) {
            this.value = this.future.join();
            this.future = null;
        }
        return this.value;
    }

    public void setValue(T value) {
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
        this.value = value;
    }
}

